/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.list.LongList;

public final class FnIndexOf
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        return new Iter(){
            final Iter input;
            final Item search;
            final Collation coll;
            int c;
            {
                this.input = FnIndexOf.this.arg(0).atomIter(qc, FnIndexOf.this.info);
                this.search = FnIndexOf.this.toAtomItem(FnIndexOf.this.arg(1), qc);
                this.coll = FnIndexOf.this.toCollation(FnIndexOf.this.arg(2), qc);
            }

            @Override
            public Int next() throws QueryException {
                Item item;
                while ((item = qc.next(this.input)) != null) {
                    ++this.c;
                    if (!FnIndexOf.this.equal(item, this.search, this.coll)) continue;
                    return Int.get(this.c);
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item item;
        Iter input = this.arg(0).atomIter(qc, this.info);
        Item search = this.toAtomItem(this.arg(1), qc);
        Collation coll = this.toCollation(this.arg(2), qc);
        LongList list = new LongList();
        int c = 0;
        while ((item = qc.next(input)) != null) {
            ++c;
            if (!this.equal(item, search, coll)) continue;
            list.add((long)c);
        }
        return IntSeq.get(list);
    }

    private boolean equal(Item item, Item search, Collation coll) throws QueryException {
        return item.comparable(search) && CmpV.OpV.EQ.eval(item, search, coll, this.sc, this.info);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr input = this.arg(0);
        SeqType st = input.seqType();
        if (st.zero()) {
            return input;
        }
        if (st.zeroOrOne() && !st.mayBeArray()) {
            this.exprType.assign(Occ.ZERO_OR_ONE);
        }
        return this;
    }
}

