/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FnFormatNumber
extends StandardFunc {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        Item value = this.arg(0).atomItem(qc, this.info);
        Type type = value.type;
        if (value.isEmpty()) {
            value = Dbl.NAN;
        } else if (type.isUntyped()) {
            value = Dbl.get(value.dbl(this.info));
        } else if (!type.isNumberOrUntyped()) {
            throw QueryError.numberError(this, value);
        }
        byte[] picture = this.toToken(this.arg(1), qc);
        QNm format = QNm.EMPTY;
        Item name = this.arg(2).atomItem(qc, this.info);
        if (name instanceof QNm) {
            format = this.toQNm(name);
        } else if (!name.isEmpty()) {
            try {
                format = QNm.resolve(Token.trim(this.toToken(name)), this.sc);
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw QueryError.FORMNUM_X.get(this.info, name);
            }
        }
        DecFormatter df = this.sc.decFormat(format.internal());
        if (df == null) {
            throw QueryError.FORMNUM_X.get(this.info, new Object[]{format.prefixId(Token.XML)});
        }
        return Str.get(df.format((ANum)value, picture, this.info));
    }
}

