/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.ArrayList;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.collation.CollationItemSet;
import org.basex.query.util.hash.HashItemSet;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;

public final class FnDistinctValues
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Iter values = this.arg(0).atomIter(qc, this.info);
        Collation coll = this.toCollation(this.arg(1), qc);
        final ItemSet set = coll == null ? new HashItemSet(false, this.info) : new CollationItemSet(coll, this.info);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(values)) != null) {
                    if (!set.add(item)) continue;
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.DATA, cc).simplifyFor(CompileContext.Simplify.DISTINCT, cc));
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr values = this.arg(0);
        SeqType st = values.seqType();
        if (st.zero()) {
            return values;
        }
        if (Function.SORT.is(values) && (values.args().length == 1 || values.arg((int)0).seqType().type.instanceOf(AtomType.ANY_ATOMIC_TYPE))) {
            ExprList list = (ExprList)new ExprList().add(values.args());
            list.set(0, cc.function(Function.DISTINCT_VALUES, this.info, values.arg(0)));
            return cc.function(Function.SORT, this.info, (Expr[])list.finish());
        }
        if (Function.DISTINCT_VALUES.is(values)) {
            return values;
        }
        Expr opt = this.optStats(cc);
        if (opt != null) {
            return opt;
        }
        AtomType type = st.type.atomic();
        if (type != null) {
            if (!this.defined(1)) {
                if (values instanceof Range || values instanceof RangeSeq || values == BlnSeq.DISTINCT) {
                    return values;
                }
                if (st.zeroOrOne() && !st.mayBeArray()) {
                    return type == st.type ? values : cc.function(Function.DATA, this.info, this.exprs);
                }
            }
            this.exprType.assign(type);
        }
        return this;
    }

    public Expr duplicates(CmpV.OpV op, CompileContext cc) throws QueryException {
        if (op == CmpV.OpV.LT) {
            return Bln.FALSE;
        }
        if (op == CmpV.OpV.GE) {
            return Bln.TRUE;
        }
        Expr dupl = cc.function(Function.DUPLICATE_VALUES, this.info, this.exprs);
        return cc.function(op == CmpV.OpV.LE || op == CmpV.OpV.EQ ? Function.EMPTY : Function.EXISTS, this.info, dupl);
    }

    private Expr optStats(CompileContext cc) throws QueryException {
        ArrayList<Stats> list;
        Expr values = this.arg(0);
        if (!this.defined(1) && values instanceof Path && (list = ((Path)values).pathStats()) != null) {
            ValueBuilder vb = new ValueBuilder(cc.qc);
            HashItemSet set = new HashItemSet(false, this.info);
            for (Stats stats : list) {
                if (!StatsType.isCategory(stats.type)) {
                    return null;
                }
                for (byte[] value : stats.values) {
                    Atm item = Atm.get(value);
                    if (!set.add(item)) continue;
                    vb.add(item);
                }
            }
            return vb.value(this);
        }
        return null;
    }
}

