/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnJsonDoc;
import org.basex.query.func.fn.FnParseUri;
import org.basex.query.func.fn.UriOptions;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public class FnBuildUri
extends FnJsonDoc {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        String fragment;
        Value segments;
        XQArray sgmnts;
        long as;
        String port;
        String userinfo;
        XQMap parts = this.toMap(this.arg(0), qc);
        UriOptions options = this.toOptions(this.arg(1), new UriOptions(), false, qc);
        TokenBuilder uri = new TokenBuilder();
        String scheme = this.get(parts, "scheme", qc);
        if (!scheme.isEmpty()) {
            uri.add(scheme);
            Value hierarchical = parts.get(Str.get("hierarchical"), this.info);
            boolean hrrchcl = hierarchical.isEmpty() || this.toBoolean(hierarchical, qc);
            uri.add(hrrchcl ? "://" : ":");
            if (scheme.equals("file") && options.get(UriOptions.UNC_PATH).booleanValue()) {
                uri.add("//");
            }
        }
        if ((userinfo = this.get(parts, "userinfo", qc)).contains(":") && !options.get(UriOptions.ALLOW_DEPRECATED_FEATURES).booleanValue()) {
            userinfo = "";
        }
        if (FnParseUri.omitPort(port = Token.string(this.toZeroToken(parts.get(Str.get("port"), this.info), qc)), scheme, options)) {
            port = "";
        }
        String host = this.get(parts, "host", qc);
        String authority = this.get(parts, "authority", qc);
        if (!(userinfo.isEmpty() && host.isEmpty() && port.isEmpty())) {
            if (!userinfo.isEmpty()) {
                uri.add(userinfo).add(64);
            }
            uri.add(host);
            if (!port.isEmpty()) {
                uri.add(58).add(port);
            }
        } else if (!authority.isEmpty()) {
            uri.add(authority);
        }
        if ((as = (sgmnts = (segments = parts.get(Str.get("path-segments"), this.info)).isEmpty() ? XQArray.empty() : this.toArray(segments, qc)).arraySize()) > 0L) {
            String sep = options.get(UriOptions.PATH_SEPARATOR);
            int a = 0;
            while ((long)a < as) {
                if (a != 0) {
                    uri.add(sep);
                }
                uri.add(Token.encodeUri(this.toToken(sgmnts.get(a), qc), false));
                ++a;
            }
        } else {
            uri.add(this.get(parts, "path", qc));
        }
        Value queries = parts.get(Str.get("query-segments"), this.info);
        XQArray qurs = queries.isEmpty() ? XQArray.empty() : this.toArray(queries, qc);
        long qs = qurs.arraySize();
        if (qs > 0L) {
            TokenBuilder query = new TokenBuilder();
            String sep = options.get(UriOptions.QUERY_SEPARATOR);
            int q = 0;
            while ((long)q < qs) {
                XQMap map = this.toMap(qurs.get(q), qc);
                byte[] key = Token.encodeUri(Token.token(this.get(map, "key", qc)), false);
                byte[] value = Token.encodeUri(Token.token(this.get(map, "value", qc)), false);
                int kl = key.length;
                int vl = value.length;
                if (kl != 0 || vl != 0) {
                    query.add(query.isEmpty() ? "?" : sep);
                    query.add(key).add(kl != 0 && vl != 0 ? "=" : "").add(value);
                }
                ++q;
            }
            uri.add(query.finish());
        }
        if (!(fragment = this.get(parts, "fragment", qc)).isEmpty()) {
            uri.add(35).add(fragment);
        }
        return Str.get(uri.finish());
    }

    protected final String get(XQMap map, String key, QueryContext qc) throws QueryException {
        Value value = map.get(Str.get(key), this.info);
        return value.isEmpty() ? "" : Token.string(this.toToken(value, qc));
    }
}

