/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.file.FileFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;

public class FileWrite
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        this.write(false, qc);
        return Empty.VALUE;
    }

    final synchronized void write(boolean append, QueryContext qc) throws QueryException, IOException {
        Path path = this.toParent(this.toPath(this.arg(0), qc));
        Iter input = this.arg(1).iter(qc);
        Item options = this.arg(2).item(qc, this.info);
        SerializerOptions sopts = FuncOptions.serializer(options, this.info);
        try (PrintOutput out = PrintOutput.get(new FileOutputStream(path.toFile(), append));
             Serializer ser = Serializer.get(out, sopts);){
            Item item;
            while ((item = qc.next(input)) != null) {
                ser.serialize(item);
            }
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
    }
}

