/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Item;
import org.basex.util.Strings;

public final class FileResolvePath
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws QueryException {
        Path abs;
        Path path = this.toPath(this.toString(this.arg(0), qc));
        if (this.defined(1)) {
            String file = this.toString(this.arg(1), qc);
            Path base = this.toPath(file);
            if (!base.isAbsolute()) {
                throw QueryError.FILE_IS_RELATIVE_X.get(this.info, base);
            }
            if (!Strings.endsWith(file, '/') && !Strings.endsWith(file, '\\')) {
                base = base.getParent();
            }
            abs = base.resolve(path).normalize();
        } else {
            abs = FileResolvePath.absolute(path);
        }
        return FileResolvePath.get(abs, Files.isDirectory(abs, new LinkOption[0]));
    }
}

