/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;

public class FileCopy
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        this.relocate(true, qc);
        return Empty.VALUE;
    }

    final synchronized void relocate(boolean copy, QueryContext qc) throws QueryException, IOException {
        Path source = this.toPath(this.arg(0), qc);
        if (!Files.exists(source, new LinkOption[0])) {
            throw QueryError.FILE_NOT_FOUND_X.get(this.info, source.toAbsolutePath());
        }
        Path src = FileCopy.absolute(source);
        Path trg = FileCopy.absolute(this.toPath(this.arg(1), qc));
        if (Files.isDirectory(trg, new LinkOption[0])) {
            trg = trg.resolve(src.getFileName());
            if (!Files.isDirectory(src, new LinkOption[0]) && Files.isDirectory(trg, new LinkOption[0])) {
                throw QueryError.FILE_IS_DIR_X.get(this.info, trg.toAbsolutePath());
            }
        } else if (!Files.exists(trg, new LinkOption[0])) {
            if (!Files.isDirectory(trg.getParent(), new LinkOption[0])) {
                throw QueryError.FILE_NO_DIR_X.get(this.info, trg.toAbsolutePath());
            }
        } else if (Files.isDirectory(src, new LinkOption[0])) {
            throw QueryError.FILE_IS_DIR_X.get(this.info, src.toAbsolutePath());
        }
        this.relocate(src, trg, copy, qc);
    }

    private synchronized void relocate(Path src, Path trg, boolean copy, QueryContext qc) throws IOException {
        if (Files.isDirectory(src, new LinkOption[0])) {
            if (!Files.exists(trg, new LinkOption[0])) {
                Files.createDirectory(trg, new FileAttribute[0]);
            }
            try (DirectoryStream<Path> children = Files.newDirectoryStream(src);){
                qc.checkStop();
                for (Path child : children) {
                    this.relocate(child, trg.resolve(child.getFileName()), copy, qc);
                }
            }
            if (!copy) {
                Files.delete(src);
            }
        } else if (copy) {
            Files.copy(src, trg, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.move(src, trg, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

