/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.db.DbAccess;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.util.Checks;
import org.basex.util.InputInfo;

public final class DbExists
extends DbAccess {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        try {
            Data data = this.toData(qc);
            if (!this.defined(1)) {
                return Bln.TRUE;
            }
            String path = this.toDbPath(this.arg(1), qc);
            Checks<ResourceType> exists = type -> {
                IOFile bin = data.meta.file(path, (ResourceType)((Object)type));
                return bin != null && bin.exists() && !bin.isDir();
            };
            return Bln.get(data.resources.doc(path) != -1 || exists.any((ResourceType[])Resources.BINARIES));
        }
        catch (QueryException ex) {
            if (ex.error() == QueryError.DB_OPEN2_X) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        try {
            return this.compileData(cc);
        }
        catch (QueryException ex) {
            if (ex.error() == QueryError.DB_OPEN2_X) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }
}

