/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.array.ArrayFn;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class ArraySubarray
extends ArrayFn {
    @Override
    public XQArray item(QueryContext qc, InputInfo ii) throws QueryException {
        XQArray array = this.toArray(this.arg(0), qc);
        long start = this.toLong(this.arg(1), qc) - 1L;
        long size = array.arraySize();
        if (start < 0L || start > size) {
            throw QueryError.ARRAYBOUNDS_X_X.get(this.info, start + 1L, size + 1L);
        }
        Item length = this.arg(2).atomItem(qc, this.info);
        if (length.isEmpty()) {
            return array.subArray(start, size - start, qc);
        }
        long len = this.toLong(length);
        if (len < 0L) {
            throw QueryError.ARRAYNEG_X.get(this.info, len);
        }
        if (start + len > size) {
            throw QueryError.ARRAYBOUNDS_X_X.get(this.info, start + 1L + len, size + 1L);
        }
        return array.subArray(start, len, qc);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Type type = this.arg((int)0).seqType().type;
        if (type instanceof ArrayType) {
            this.exprType.assign(type);
        }
        return this;
    }
}

