/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;

public final class ArrayMembers
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final XQArray array = this.toArray(this.arg(0), qc);
        return new Iter(){
            final Iterator<Value> members;
            {
                this.members = array.members().iterator();
            }

            @Override
            public XQMap next() throws QueryException {
                return this.members.hasNext() ? ArrayMembers.this.record(this.members.next()) : null;
            }

            @Override
            public Item get(long i) throws QueryException {
                return ArrayMembers.this.record(array.get(i));
            }

            @Override
            public long size() {
                return array.arraySize();
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        XQArray array = this.toArray(this.arg(0), qc);
        ValueBuilder vb = new ValueBuilder(qc);
        for (Value member : array.members()) {
            vb.add(this.record(member));
        }
        return vb.value(this);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        FuncType ft = this.arg(0).funcType();
        if (ft instanceof ArrayType) {
            this.exprType.assign(MapType.get(AtomType.STRING, ft.declType));
        }
        return this;
    }

    private XQMap record(Value value) throws QueryException {
        return XQMap.entry(Str.VALUE, value, this.info);
    }
}

