/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.Map;
import org.basex.io.in.BufferInput;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveCreate;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.GZIPIn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;

public final class ArchiveUpdate
extends ArchiveCreate {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        B64 archive = this.toB64(this.arg(0), qc);
        Map<String, Item[]> map = this.toMap(this.arg(1), this.arg(2), qc);
        try (BufferInput bi = archive.input(this.info);){
            ArchiveIn in = ArchiveIn.get(bi, this.info);
            try {
                String format = in.format();
                if (in instanceof GZIPIn) {
                    throw QueryError.ARCHIVE_MODIFY_X.get(this.info, format);
                }
                ArrayOutput ao = new ArrayOutput();
                try (ArchiveOut out = ArchiveOut.get(format, this.info, ao);){
                    while (in.more()) {
                        Item[] entry = map.remove(in.entry().getName());
                        if (entry != null) {
                            this.add(entry, out, 8, "", qc);
                            continue;
                        }
                        out.write(in);
                    }
                    for (Item[] entry : map.values()) {
                        this.add(entry, out, 8, "", qc);
                    }
                }
                B64 b64 = B64.get(ao.finish());
                if (in != null) {
                    in.close();
                }
                return b64;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
    }
}

