/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.basex.io.in.BufferInput;
import org.basex.io.in.LookupInput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.GZIPIn;
import org.basex.query.func.archive.ZIPIn;
import org.basex.util.InputInfo;

abstract class ArchiveIn
implements Closeable {
    ArchiveIn() {
    }

    static ArchiveIn get(BufferInput bi, InputInfo ii) throws QueryException {
        try {
            LookupInput li = new LookupInput(bi);
            if (li.lookup() == 80) {
                return new ZIPIn(li);
            }
            if (li.lookup() == 31) {
                return new GZIPIn(li);
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(ii, ex);
        }
        throw QueryError.ARCHIVE_FORMAT.get(ii, new Object[0]);
    }

    public abstract boolean more() throws IOException;

    public abstract ZipEntry entry();

    public abstract String format();

    public abstract int read(byte[] var1) throws IOException;

    final void write(OutputStream out) throws IOException {
        int c;
        byte[] data = new byte[4096];
        while ((c = this.read(data)) != -1) {
            out.write(data, 0, c);
        }
    }

    @Override
    public abstract void close();
}

