/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.admin;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.basex.core.users.UserText;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.admin.AdminFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.server.Log;
import org.basex.server.LogEntry;
import org.basex.server.LogFile;
import org.basex.util.Strings;

public final class AdminLogs
extends AdminFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        String date = this.toStringOrNull(this.arg(0), qc);
        return date == null ? this.list(qc).iter() : this.logs(date, qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        String date = this.toStringOrNull(this.arg(0), qc);
        return date == null ? this.list(qc) : this.logs(date, qc).value(qc, this);
    }

    private Value list(QueryContext qc) {
        ValueBuilder vb = new ValueBuilder(qc);
        for (IOFile file : qc.context.log.files()) {
            String date = file.name().replace(".log", "");
            vb.add(FElem.build(Q_FILE).add(Q_SIZE, file.length()).add(date).finish());
        }
        return vb.value(this);
    }

    private Iter logs(String date, QueryContext qc) throws QueryException {
        final boolean merge = this.toBooleanOrFalse(this.arg(1), qc);
        LogFile file = qc.context.log.file(date);
        if (file == null) {
            throw QueryError.WHICHRES_X.get(this.info, date);
        }
        final LinkedList<LogEntry> list = this.logs(file, qc);
        final HashMap<String, LinkedList> map = new HashMap<String, LinkedList>();
        if (merge) {
            for (LogEntry entry : list) {
                map.computeIfAbsent(entry.address, address -> new LinkedList()).add(entry);
            }
        }
        final Pattern digits = Pattern.compile("\\d+");
        return new Iter(){

            @Override
            public Item next() {
                LogEntry entry;
                while ((entry = (LogEntry)list.pollFirst()) != null) {
                    if (merge) {
                        LinkedList entries = (LinkedList)map.get(entry.address);
                        if (entries.peekFirst() != entry) continue;
                        entries.removeFirst();
                        if (entry.type != null && entry.type.equals(Log.LogType.REQUEST.name())) {
                            Iterator iter = entries.iterator();
                            while (iter.hasNext()) {
                                LogEntry next = (LogEntry)iter.next();
                                String type = next.type;
                                if (type.equals(Log.LogType.REQUEST.name())) break;
                                if (!digits.matcher(type).matches() && !Strings.eq(type, Log.LogType.OK.name(), Log.LogType.ERROR.name())) continue;
                                entry.type = type;
                                entry.user = next.user;
                                entry.ms = entry.ms.add(next.ms);
                                String msg1 = entry.message;
                                String msg2 = next.message;
                                if (!msg2.isEmpty()) {
                                    entry.message = msg1.isEmpty() ? msg2 : msg1 + "; " + msg2;
                                }
                                iter.remove();
                                break;
                            }
                        }
                    }
                    FBuilder elem = FElem.build(AdminFn.Q_ENTRY).add(entry.message);
                    if (entry.address != null) {
                        elem.add(AdminFn.Q_TIME, entry.time).add(AdminFn.Q_ADDRESS, entry.address);
                        elem.add(UserText.Q_USER, entry.user).add(AdminFn.Q_TYPE, entry.type);
                        if (entry.ms != BigDecimal.ZERO) {
                            elem.add(AdminFn.Q_MS, entry.ms);
                        }
                    }
                    return elem.finish();
                }
                return null;
            }
        };
    }

    private LinkedList<LogEntry> logs(LogFile file, QueryContext qc) throws QueryException {
        try {
            LinkedList<LogEntry> logs = new LinkedList<LogEntry>();
            for (String line : file.read()) {
                qc.checkStop();
                LogEntry entry = new LogEntry();
                String[] cols = line.split("\t");
                if (cols.length > 2) {
                    int i;
                    entry.time = cols[0];
                    entry.address = cols[1];
                    entry.user = cols[2];
                    entry.type = cols.length > 3 ? cols[3] : "";
                    entry.message = cols.length > 4 ? cols[4] : "";
                    entry.ms = BigDecimal.ZERO;
                    if (cols.length > 5 && (i = cols[5].indexOf(" ms")) > -1) {
                        entry.ms = new BigDecimal(cols[5].substring(0, i));
                    }
                } else {
                    entry.message = line;
                }
                logs.add(entry);
            }
            return logs;
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }
}

