/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.value.Value;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public interface XQFunction
extends XQFunctionExpr {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Value invoke(QueryContext qc, InputInfo ii, Value ... args) throws QueryException {
        XQFunction fn = this;
        Value[] values = args;
        int fp = qc.stack.enterFrame(fn.stackFrameSize());
        try {
            while (true) {
                qc.checkStop();
                Value value = fn.invokeInternal(qc, ii, values);
                fn = qc.pollTailCall();
                if (fn == null) {
                    Value value2 = value;
                    return value2;
                }
                qc.stack.reuseFrame(fn.stackFrameSize());
                values = qc.pollTailArgs();
                continue;
                break;
            }
        }
        catch (QueryException ex) {
            throw ex.add(ii);
        }
        finally {
            qc.stack.exitFrame(fp);
        }
    }

    default public Value invokeTail(QueryContext qc, InputInfo ii, Value ... args) throws QueryException {
        qc.checkStop();
        int calls = qc.tailCalls;
        int max = qc.maxCalls;
        if (max >= 0 && calls >= max) {
            qc.registerTailCall(this, args);
            return Empty.VALUE;
        }
        ++qc.tailCalls;
        int fp = qc.stack.enterFrame(this.stackFrameSize());
        try {
            Value value = this.invokeInternal(qc, ii, args);
            return value;
        }
        catch (QueryException ex) {
            throw ex.add(ii);
        }
        finally {
            qc.tailCalls = calls;
            qc.stack.exitFrame(fp);
        }
    }

    public Value invokeInternal(QueryContext var1, InputInfo var2, Value[] var3) throws QueryException;

    public int stackFrameSize();
}

