/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.basex.core.Text;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Closure;
import org.basex.query.func.Functions;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.TypedFunc;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.parse.Params;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class StaticFuncs
extends ExprInfo {
    private final TokenObjMap<FuncCache> funcs = new TokenObjMap();
    private Map<StaticFunc, ArrayList<StaticFuncCall>> callsMap;

    public StaticFunc declare(QNm qname, Params params, Expr expr, AnnList anns, String doc, VarScope vs, InputInfo ii) throws QueryException {
        byte[] uri = qname.uri();
        if (uri.length == 0) {
            throw QueryError.FUNNONS_X.get(ii, new Object[]{qname.string()});
        }
        if (NSGlobal.reserved(uri) || Functions.builtIn(qname) != null) {
            throw QueryError.FNRESERVED_X.get(ii, new Object[]{qname.string()});
        }
        StaticFunc sf = new StaticFunc(qname, params, expr, anns, doc, vs, ii);
        this.funcCache(sf.id()).setFunc(sf);
        return sf;
    }

    TypedFunc funcCall(QNm qname, Expr[] args, StaticContext sc, InputInfo ii) throws QueryException {
        FuncCache fc = this.funcs.get(StaticFunc.id(qname, args.length));
        return fc == null ? null : fc.newCall(qname, args, sc, ii);
    }

    TypedFunc undeclaredFuncCall(QNm qname, Expr[] args, StaticContext sc, InputInfo ii) throws QueryException {
        if (NSGlobal.reserved(qname.uri())) {
            throw this.similarError(qname, ii);
        }
        return this.funcCache(StaticFunc.id(qname, args.length)).newCall(qname, args, sc, ii);
    }

    public void registerFuncLiteral(Closure literal) {
        this.funcCache((byte[])StaticFunc.id((QNm)literal.funcName(), (long)((long)literal.arity()))).literals.add(literal);
    }

    public void check(QueryContext qc) throws QueryException {
        for (FuncCache fc : this.funcs.values()) {
            StaticFuncCall call;
            StaticFuncCall staticFuncCall = call = fc.calls.isEmpty() ? null : fc.calls.get(0);
            if (fc.func == null) {
                IntList arities = new IntList();
                for (FuncCache ofc : this.funcs.values()) {
                    if (fc == ofc || ofc.func == null || !call.name.eq(ofc.qname())) continue;
                    arities.add(ofc.func.arity());
                }
                if (arities.isEmpty()) {
                    throw this.similarError(call.name, call.info());
                }
                throw Functions.wrongArity(call.name.string(), call.exprs.length, arities, call.info());
            }
            if (call == null) continue;
            if (fc.func.expr == null) {
                throw QueryError.FUNCNOIMPL_X.get(call.info(), new Object[]{call.name.prefixString()});
            }
            if (qc.updating) continue;
            qc.updating = fc.func.updating;
        }
    }

    public void checkUp() throws QueryException {
        for (FuncCache fc : this.funcs.values()) {
            fc.func.checkUp();
        }
    }

    public void compileAll(CompileContext cc) {
        for (FuncCache fc : this.funcs.values()) {
            fc.func.compile(cc);
        }
    }

    public StaticFunc get(QNm qname, long arity) {
        FuncCache fc = this.funcs.get(StaticFunc.id(qname, arity));
        return fc != null ? fc.func : null;
    }

    SeqType[] seqTypes(StaticFunc func) {
        if (this.callsMap == null) {
            this.callsMap = new IdentityHashMap<StaticFunc, ArrayList<StaticFuncCall>>(this.funcs.size());
            for (FuncCache fc : this.funcs.values()) {
                if (func.params.length <= 0 || fc.calls.isEmpty()) continue;
                this.callsMap.put(fc.func, fc.calls);
            }
        }
        if (!this.callsMap.containsKey(func)) {
            return null;
        }
        int sl = func.params.length;
        SeqType[] seqTypes = new SeqType[sl];
        for (StaticFuncCall call : this.callsMap.get(func)) {
            for (int s = 0; s < sl; ++s) {
                SeqType st = call.arg(s).seqType();
                SeqType stOld = seqTypes[s];
                seqTypes[s] = stOld == null ? st : stOld.union(st);
            }
        }
        return seqTypes;
    }

    private QueryException similarError(QNm qname, InputInfo ii) {
        ArrayList<QNm> list = new ArrayList<QNm>();
        for (FuncCache fc : this.funcs.values()) {
            StaticFunc sf = fc.func;
            if (sf == null || sf.expr == null) continue;
            list.add(sf.name);
        }
        Object similar = Levenshtein.similar(qname.local(), list.toArray(QNm[]::new), o -> ((QNm)o).local());
        return QueryError.WHICHFUNC_X.get(ii, new Object[]{similar != null ? QueryError.similar(qname.prefixString(), ((QNm)similar).prefixString()) : Functions.similar(qname)});
    }

    public StaticFunc[] funcs() {
        int fs = this.funcs.size();
        StaticFunc[] sf = new StaticFunc[fs];
        int i = 0;
        for (FuncCache fc : this.funcs.values()) {
            sf[i++] = fc.func;
        }
        return sf;
    }

    @Override
    public void toXml(QueryPlan plan) {
        if (this.funcs.isEmpty()) {
            return;
        }
        ArrayList<StaticFunc> list = new ArrayList<StaticFunc>(this.funcs.size());
        for (FuncCache fc : this.funcs.values()) {
            list.add(fc.func);
        }
        plan.add(plan.create(this, new Object[0]), list.toArray());
    }

    @Override
    public void toString(QueryString qs) {
        for (FuncCache fc : this.funcs.values()) {
            if (fc.func == null || !fc.func.compiled()) continue;
            qs.token(fc.func).token(Text.NL);
        }
    }

    private FuncCache funcCache(byte[] id) {
        return this.funcs.computeIfAbsent(id, () -> new FuncCache());
    }

    private static class FuncCache {
        final ArrayList<StaticFuncCall> calls = new ArrayList(0);
        final ArrayList<Closure> literals = new ArrayList(0);
        StaticFunc func;

        private FuncCache() {
        }

        void setFunc(StaticFunc sf) throws QueryException {
            if (this.func != null) {
                throw QueryError.FUNCDEFINED_X.get(sf.info, new Object[]{sf.name.string()});
            }
            this.func = sf;
            for (StaticFuncCall call : this.calls) {
                call.init(sf);
            }
            FuncType ft = sf.funcType();
            for (Closure literal : this.literals) {
                literal.adoptSignature(ft);
            }
        }

        TypedFunc newCall(QNm qname, Expr[] args, StaticContext sc, InputInfo ii) throws QueryException {
            StaticFuncCall call = new StaticFuncCall(qname, args, sc, ii);
            this.calls.add(call);
            return this.func != null ? new TypedFunc(call.init(this.func), this.func.anns) : new TypedFunc(call);
        }

        QNm qname() {
            return this.func != null ? this.func.name : this.calls.get((int)0).name;
        }
    }
}

