/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.core.BaseXException;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.path.NameTest;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.options.Options;

public final class FuncOptions {
    public static final QNm Q_SERIALIZTION_PARAMETERS = new QNm(QueryText.OUTPUT_PREFIX, "serialization-parameters", QueryText.OUTPUT_URI);
    private static final byte[] VALUE = Token.token("value");
    private final QNm root;
    private final NameTest test;
    private final InputInfo info;
    private boolean enforceKnown;

    public FuncOptions(InputInfo info) {
        this(null, info);
    }

    public FuncOptions(QNm root, InputInfo info) {
        this.test = root == null ? null : new NameTest(root);
        this.root = root;
        this.info = info;
    }

    public <T extends Options> T assign(Item item, T options, boolean enforce) throws QueryException {
        this.enforceKnown = enforce;
        return this.assign(item, options, QueryError.INVALIDOPT_X);
    }

    private <T extends Options> T assign(Item item, T options, QueryError error) throws QueryException {
        if (!item.isEmpty()) {
            try {
                if (item instanceof XQMap) {
                    options.assign((XQMap)item, this.enforceKnown, this.info);
                } else {
                    Type type = item.type;
                    if (this.test == null) {
                        throw QueryError.MAP_X_X.get(this.info, type, item);
                    }
                    if (!this.test.matches(item)) {
                        throw QueryError.ELMMAP_X_X_X.get(this.info, this.root.prefixId(Token.XML), type, item);
                    }
                    options.assign(this.toString((ANode)item, error));
                }
            }
            catch (BaseXException ex) {
                throw error.get(this.info, ex);
            }
        }
        return options;
    }

    private String toString(ANode node, QueryError error) throws QueryException {
        ANode n = node.attributeIter().next();
        if (n != null) {
            throw error.get(this.info, Util.info("Invalid attribute: '%'", new Object[]{n.name()}));
        }
        TokenBuilder tb = new TokenBuilder();
        for (ANode child : node.childIter()) {
            if (child.type != NodeType.ELEMENT) continue;
            QNm qname = child.qname();
            if (!Token.eq(qname.uri(), this.root.uri())) {
                if (qname.uri().length != 0) continue;
                throw error.get(this.info, Util.info("Element has no namespace: '%'", qname));
            }
            String name = Token.string(qname.local());
            String value = null;
            if (name.equals(SerializerOptions.USE_CHARACTER_MAPS.name())) {
                value = SerializerOptions.characterMap(child);
                if (value == null) {
                    throw error.get(this.info, "Character map is invalid.");
                }
            } else if (FuncOptions.hasElements(child)) {
                value = this.toString(child, error);
            } else {
                for (ANode attr : child.attributeIter()) {
                    if (Token.eq(attr.name(), VALUE)) {
                        value = Token.string(attr.string());
                        if (!name.equals(SerializerOptions.CDATA_SECTION_ELEMENTS.name())) continue;
                        value = FuncOptions.cDataSectionElements(child, value);
                        continue;
                    }
                    throw error.get(this.info, Util.info("Invalid attribute: '%'", new Object[]{attr.name()}));
                }
                if (value == null) {
                    value = Token.string(child.string());
                }
            }
            tb.add(name).add(61).add(value.trim().replace(",", ",,")).add(44);
        }
        return tb.toString();
    }

    private static String cDataSectionElements(ANode elem, String value) {
        if (!Strings.contains(value, ':')) {
            return value;
        }
        TokenBuilder tb = new TokenBuilder();
        for (byte[] name : Token.split(Token.normalize(Token.token(value)), 32)) {
            int i = Token.indexOf(name, 58);
            if (i == -1) {
                tb.add(name);
            } else {
                byte[] vl = elem.nsScope(null).value(Token.substring(name, 0, i));
                if (vl != null) {
                    tb.add(QNm.eqName(vl, Token.substring(name, i + 1)));
                } else {
                    tb.add(name);
                }
            }
            tb.add(32);
        }
        return tb.toString();
    }

    private static boolean hasElements(ANode node) {
        for (ANode nd : node.childIter()) {
            if (nd.type != NodeType.ELEMENT) continue;
            return true;
        }
        return false;
    }

    public static SerializerOptions serializer(Item item, InputInfo ii) throws QueryException {
        SerializerOptions sopts = new SerializerOptions();
        sopts.set(SerializerOptions.METHOD, SerialMethod.XML);
        return FuncOptions.serializer(item, sopts, ii);
    }

    public static SerializerOptions serializer(Item item, SerializerOptions sopts, InputInfo ii) throws QueryException {
        return new FuncOptions(Q_SERIALIZTION_PARAMETERS, ii).assign(item, sopts, QueryError.SEROPT_X);
    }
}

