/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class FuncLit
extends Single
implements Scope {
    private final VarScope vs;
    private final QNm name;
    private final Var[] params;
    private final AnnList anns;

    FuncLit(AnnList anns, QNm name, Var[] params, Expr expr, SeqType seqType, VarScope vs, InputInfo info) {
        super(info, expr, seqType);
        this.anns = anns;
        this.name = name;
        this.params = params;
        this.vs = vs;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
            this.expr.markTailCalls(null);
        }
        catch (QueryException e) {
            this.expr = cc.error(e, this);
        }
        finally {
            cc.removeScope(this);
        }
        return this.optimize(cc);
    }

    @Override
    public boolean compiled() {
        return true;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) {
        return new FuncItem(this.vs.sc, this.anns, this.name, this.params, this.funcType(), this.expr, this.vs.stackSize(), this.info, qc.focus.copy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        VarScope vsc = new VarScope(this.vs.sc);
        cc.pushScope(vsc);
        try {
            int pl = this.params.length;
            Var[] vars = new Var[pl];
            for (int p = 0; p < pl; ++p) {
                vars[p] = cc.copy(this.params[p], vm);
            }
            Expr ex = this.expr.copy(cc, vm);
            FuncLit funcLit = this.copyType(new FuncLit(this.anns, this.name, vars, ex, this.seqType(), vsc, this.info));
            return funcLit;
        }
        finally {
            cc.removeScope();
        }
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Var var : this.params) {
            if (visitor.declared(var)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.inlineFunc(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public void toString(QueryString qs) {
        qs.concat(this.name.prefixId(), "#", this.params.length);
    }
}

