/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.EnumSet;
import java.util.function.Supplier;
import org.basex.core.users.Perm;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Flag;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class FuncDefinition {
    public final SeqType seqType;
    final Supplier<? extends StandardFunc> supplier;
    final int[] minMax;
    final SeqType[] types;
    final QNm[] names;
    final byte[] uri;
    final Perm perm;
    private final String desc;
    private final EnumSet<Flag> flags;

    FuncDefinition(Supplier<? extends StandardFunc> supplier, String desc, SeqType[] types, SeqType seqType, EnumSet<Flag> flags, byte[] uri, Perm perm) {
        this.supplier = supplier;
        this.desc = desc;
        this.seqType = seqType;
        this.types = types;
        this.flags = flags;
        this.uri = uri;
        this.perm = perm;
        this.minMax = FuncDefinition.minMax(desc, types);
        int p = desc.indexOf(40);
        String[] tmp = Strings.split(desc.substring(p + 1).replace(",...", "").replaceAll("[\\[\\])\\s]", ""), ',');
        int tl = tmp.length == 1 && tmp[0].isEmpty() ? 0 : tmp.length;
        this.names = new QNm[tl];
        for (int n = 0; n < tl; ++n) {
            this.names[n] = new QNm(tmp[n]);
        }
        if (flags.contains((Object)Flag.UPD)) {
            flags.add(Flag.NDT);
        }
    }

    public static int[] minMax(String desc, SeqType[] params) {
        int optional = desc.indexOf(91);
        int pl = params.length;
        if (optional == -1) {
            return new int[]{pl, pl};
        }
        int c = desc.charAt(optional + 1) == ',' ? 1 : 0;
        for (int i = 0; i < optional; ++i) {
            if (desc.charAt(i) != ',') continue;
            ++c;
        }
        return new int[]{c, desc.contains("...") ? Integer.MAX_VALUE : pl};
    }

    public byte[] uri() {
        return this.uri;
    }

    public boolean has(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public int indexOf(QNm name) {
        for (int n = this.names.length - 1; n >= 0; --n) {
            if (!name.eq(this.names[n])) continue;
            return n;
        }
        return -1;
    }

    FuncType type(int arity, AnnList anns) {
        SeqType[] st = new SeqType[arity];
        if (arity != 0 && this.variadic()) {
            int tl = this.types.length;
            Array.copy(this.types, tl, st);
            SeqType var = this.types[tl - 1];
            for (int t = tl; t < arity; ++t) {
                st[t] = var;
            }
        } else {
            Array.copy(this.types, arity, st);
        }
        return FuncType.get(anns, this.seqType, st);
    }

    QNm[] paramNames(int arity) {
        QNm[] qnms = new QNm[arity];
        int nl = this.names.length;
        int n = Math.min(arity, nl);
        while (--n >= 0) {
            qnms[n] = this.names[n];
        }
        if (arity > nl) {
            String[] parts = Token.string(this.names[nl - 1].local()).split("(?=\\d+$)", 2);
            int start = Integer.parseInt(parts[1]);
            for (int n2 = nl; n2 < arity; ++n2) {
                qnms[n2] = new QNm(parts[0] + (start + n2 - nl + 1), "");
            }
        }
        return qnms;
    }

    public byte[] local() {
        return Token.token(this.desc.substring(0, this.desc.indexOf(40)));
    }

    byte[] id() {
        TokenBuilder tb = new TokenBuilder();
        if (!Token.eq(this.uri, QueryText.FN_URI)) {
            tb.add(NSGlobal.prefix(this.uri)).add(58);
        }
        return tb.add(this.local()).finish();
    }

    public boolean variadic() {
        return this.minMax[1] == Integer.MAX_VALUE;
    }

    String args(Object ... args) {
        TokenBuilder tb = new TokenBuilder();
        for (Object arg : args) {
            if (!tb.isEmpty()) {
                tb.add(", ");
            }
            if (arg instanceof Expr || arg instanceof Number) {
                tb.add(arg);
                continue;
            }
            if (arg instanceof Boolean) {
                tb.add(arg + "()");
                continue;
            }
            String str = arg.toString();
            if (Strings.startsWith(str, ' ')) {
                tb.add(str.substring(1));
                continue;
            }
            tb.add("\"" + str.replace("\"", "\"\"") + "\"");
        }
        return " " + this.toString().replaceAll("\\(.*", "(") + tb + ")";
    }

    public StandardFunc get(StaticContext sc, InputInfo ii, Expr ... args) {
        StandardFunc sf = this.supplier.get();
        sf.init(sc, ii, this, args);
        return sf;
    }

    public String toString() {
        return Strings.concat(NSGlobal.prefix(this.uri), ":", this.desc);
    }
}

