/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.StringRange;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.func.Function;
import org.basex.query.iter.DBNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.type.NodeType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;

public final class StringRangeAccess
extends IndexAccess {
    private final StringRange index;

    public StringRangeAccess(InputInfo info, StringRange index, IndexDb db) {
        super(db, info, index.type() == IndexType.TEXT ? NodeType.TEXT : NodeType.ATTRIBUTE);
        this.index = index;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final IndexType type = this.index.type();
        Data data = this.db.data(qc, type);
        return new DBNodeIter(data){
            final byte kind;
            final IndexIterator ii;
            {
                super(data);
                this.kind = (byte)(type == IndexType.TEXT ? 2 : 3);
                this.ii = StringRangeAccess.this.index.min.length <= this.data.meta.maxlen && StringRangeAccess.this.index.max.length <= this.data.meta.maxlen ? this.data.iter(StringRangeAccess.this.index) : StringRangeAccess.this.scan(this.data);
            }

            @Override
            public DBNode next() {
                return this.ii.more() ? new DBNode(this.data, this.ii.pre(), this.kind) : null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        IndexType it = this.index.type();
        Data data = this.db.data(qc, it);
        IndexIterator ii = this.index.min.length <= data.meta.maxlen && this.index.max.length <= data.meta.maxlen ? data.iter(this.index) : this.scan(data);
        IntList list = new IntList();
        while (ii.more()) {
            list.add(ii.pre());
        }
        return DBNodeSeq.get(list.finish(), data, this);
    }

    private IndexIterator scan(final Data data) {
        return new IndexIterator(){
            final boolean text;
            final byte kind;
            final int sz;
            int pre;
            {
                this.text = StringRangeAccess.this.index.type() == IndexType.TEXT;
                this.kind = (byte)(this.text ? 2 : 3);
                this.sz = data.meta.size;
                this.pre = -1;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.sz) {
                    if (data.kind(this.pre) != this.kind) continue;
                    byte[] txt = data.text(this.pre, this.text);
                    int min = Token.diff(txt, StringRangeAccess.this.index.min);
                    int max = Token.diff(txt, StringRangeAccess.this.index.max);
                    if (min < (StringRangeAccess.this.index.mni ? 0 : 1) || max > (StringRangeAccess.this.index.mxi ? 0 : 1)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return Math.max(1, this.sz >>> 2);
            }
        };
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        return this.inlineDb(ic) ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new StringRangeAccess(this.info, this.index, (IndexDb)this.db.copy(cc, (IntObjMap)vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StringRangeAccess && this.index.equals(((StringRangeAccess)obj).index) && super.equals(obj);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[]{"index", this.index.type(), "min", this.index.min, "max", this.index.max}), this.db);
    }

    @Override
    public void toString(QueryString qs) {
        Function function = this.index.type() == IndexType.TEXT ? Function._DB_TEXT_RANGE : Function._DB_ATTRIBUTE_RANGE;
        qs.function(function, this.db, Str.get(this.index.min), Str.get(this.index.max));
    }
}

