/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.Condition;
import org.basex.query.expr.gflwor.Eval;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Window
extends Clause {
    private final boolean sliding;
    private final Var var;
    private Expr expr;
    private Condition start;
    private final boolean only;
    private Condition end;

    public Window(boolean sliding, Var var, Expr expr, Condition start, boolean only, Condition end) throws QueryException {
        super(var.info, SeqType.ITEM_ZM, Window.vars(var, start, end));
        this.sliding = sliding;
        this.var = var;
        this.expr = expr;
        this.start = start;
        this.only = only;
        this.end = end;
    }

    private static Var[] vars(Var vr, Condition st, Condition nd) throws QueryException {
        int stn = st.nVars();
        Var[] vs = new Var[1 + stn + (nd == null ? 0 : nd.nVars())];
        st.writeVars(vs, 0);
        if (nd != null) {
            nd.writeVars(vs, stn);
        }
        int vl = vs.length;
        vs[vl - 1] = vr;
        for (int v = 0; v < vl; ++v) {
            Var var = vs[v];
            int w = v;
            while (--w >= 0) {
                if (!var.name.eq(vs[w].name)) continue;
                throw QueryError.DUPLWIND_X.get(vr.info, vs[w]);
            }
        }
        return vs;
    }

    @Override
    Eval eval(Eval sub) {
        return this.sliding ? this.slidingEval(sub) : (this.end == null ? this.tumblingEval(sub) : this.tumblingEndEval(sub));
    }

    private Eval tumblingEval(final Eval sub) {
        return new TumblingEval(){
            private Item[] vals;
            private long spos;

            @Override
            public boolean next(QueryContext qc) throws QueryException {
                while (true) {
                    Item fst;
                    Item item = this.vals != null ? this.vals[0] : (fst = this.findStart(qc) ? this.curr : null);
                    if (fst != null) {
                        Item[] itemArray;
                        ValueBuilder vb = new ValueBuilder(qc).add(fst);
                        if (this.vals == null) {
                            Item[] itemArray2 = new Item[3];
                            itemArray2[0] = this.curr;
                            itemArray2[1] = this.prev;
                            itemArray = itemArray2;
                            itemArray2[2] = this.next;
                        } else {
                            itemArray = this.vals;
                        }
                        Item[] st = itemArray;
                        long ps = this.vals == null ? this.pos : this.spos;
                        this.vals = null;
                        while (this.readNext()) {
                            if (Window.this.start.matches(qc, this.curr, this.pos, this.prev, this.next)) {
                                this.vals = new Item[]{this.curr, this.prev, this.next};
                                this.spos = this.pos;
                                break;
                            }
                            vb.add(this.curr);
                        }
                        Window.this.start.bind(qc, st[0], ps, st[1], st[2]);
                        qc.set(Window.this.var, vb.value(Window.this));
                        return true;
                    }
                    if (!this.prepareNext(qc, sub)) {
                        return false;
                    }
                    this.vals = null;
                }
            }
        };
    }

    private Eval tumblingEndEval(final Eval sub) {
        return new TumblingEval(){

            @Override
            public boolean next(QueryContext qc) throws QueryException {
                do {
                    if (!this.findStart(qc)) continue;
                    ValueBuilder vb = new ValueBuilder(qc);
                    boolean found = false;
                    do {
                        vb.add(this.curr);
                        if (!Window.this.end.matches(qc, this.curr, this.pos, this.prev, this.next)) continue;
                        found = true;
                        break;
                    } while (this.readNext());
                    if (!found && Window.this.only) continue;
                    qc.set(Window.this.var, vb.value(Window.this));
                    return true;
                } while (this.prepareNext(qc, sub));
                return false;
            }
        };
    }

    private Eval slidingEval(final Eval sub) {
        return new WindowEval(){
            private final ArrayDeque<Item> queue = new ArrayDeque();

            @Override
            public boolean next(QueryContext qc) throws QueryException {
                while (true) {
                    Item curr;
                    Item next = null;
                    while ((curr = this.advance()) != null) {
                        next = this.queue.peekFirst();
                        if (next == null && (next = this.next()) != null) {
                            this.queue.addLast(next);
                        }
                        if (Window.this.start.matches(qc, curr, this.pos, this.prev, next)) break;
                        this.prev = curr;
                    }
                    if (curr != null) {
                        ValueBuilder vb = new ValueBuilder(qc);
                        Iterator<Item> iter = this.queue.iterator();
                        if (iter.hasNext()) {
                            iter.next();
                        }
                        Item pr = this.prev;
                        Item it = curr;
                        Item nx = next;
                        long ps = this.pos;
                        do {
                            vb.add(it);
                            if (Window.this.end.matches(qc, it, ps++, pr, nx)) break;
                            pr = it;
                            it = nx;
                            if (iter.hasNext()) {
                                nx = iter.next();
                                continue;
                            }
                            nx = this.next();
                            if (nx == null) continue;
                            this.queue.addLast(nx);
                        } while (it != null);
                        if (it != null || !Window.this.only) {
                            Window.this.start.bind(qc, curr, this.pos, this.prev, next);
                            this.prev = curr;
                            qc.set(Window.this.var, vb.value(Window.this));
                            return true;
                        }
                    }
                    if (!this.prepareNext(qc, sub)) {
                        return false;
                    }
                    this.queue.clear();
                }
            }

            private Item advance() throws QueryException {
                Item item = this.queue.pollFirst();
                if (item == null) {
                    item = this.next();
                }
                if (item != null) {
                    ++this.pos;
                }
                return item;
            }
        };
    }

    @Override
    public Clause compile(CompileContext cc) throws QueryException {
        this.expr = this.expr.compile(cc);
        this.start.compile(this.expr, cc);
        if (this.end != null) {
            this.end.compile(this.expr, cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Clause optimize(CompileContext cc) throws QueryException {
        this.exprType.assign(this.expr.seqType().union(Occ.ZERO));
        this.var.refineType(this.seqType(), cc);
        return this;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.expr.has(flags) || this.start.has(flags) || this.end != null && this.end.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext v) {
        return this.expr.inlineable(v) && this.start.inlineable(v) && (this.end == null || this.end.inlineable(v));
    }

    @Override
    public VarUsage count(Var v) {
        VarUsage us = this.end == null ? this.start.count(v) : this.start.count(v).plus(this.end.count(v));
        return us == VarUsage.NEVER ? this.expr.count(v) : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public Clause inline(InlineContext ic) throws QueryException {
        Condition en;
        Expr inlined = this.expr.inline(ic);
        Condition st = this.start.inline(ic);
        Condition condition = en = this.end == null ? null : this.end.inline(ic);
        if (inlined != null) {
            this.expr = inlined;
        }
        if (st != null) {
            this.start = st;
        }
        if (en != null) {
            this.end = en;
        }
        return inlined != null || st != null || en != null ? this.optimize(ic.cc) : null;
    }

    @Override
    public Window copy(CompileContext cc, IntObjMap<Var> vm) {
        try {
            return this.copyType(new Window(this.sliding, cc.copy(this.var, vm), this.expr.copy(cc, vm), (Condition)this.start.copy(cc, (IntObjMap)vm), this.only, (Condition)(this.end != null ? this.end.copy(cc, (IntObjMap)vm) : null)));
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && this.start.accept(visitor) && (this.end == null || this.end.accept(visitor)) && visitor.declared(this.var);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
        this.checkNoUp(this.start);
        this.checkNoUp(this.end);
    }

    @Override
    public void calcSize(long[] minMax) {
        minMax[0] = 0L;
        minMax[1] = this.expr.seqType().zero() ? 0L : -1L;
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize() + this.start.exprSize() + (this.end == null ? 0 : this.end.exprSize());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Window)) {
            return false;
        }
        Window w = (Window)obj;
        return this.sliding == w.sliding && this.var.equals(w.var) && this.expr.equals(w.expr) && this.start.equals(w.start) && this.only == w.only && Objects.equals(this.end, w.end);
    }

    @Override
    public void toXml(QueryPlan plan) {
        FBuilder elem = plan.attachVariable(plan.create(this, "sliding", this.sliding), this.var, false);
        plan.add(elem, this.start, this.end, this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("for").token(this.sliding ? "sliding" : "tumbling").token("window").token(this.var).token("in").token(this.expr).token(this.start);
        if (this.end != null) {
            if (this.only) {
                qs.token("only");
            }
            qs.token(this.end);
        }
    }

    private abstract class TumblingEval
    extends WindowEval {
        private final boolean popNext;
        Item curr;
        Item next;

        private TumblingEval() {
            this.popNext = Window.this.start.usesNext() || Window.this.end != null && Window.this.end.usesNext();
        }

        final boolean readNext() throws QueryException {
            this.prev = this.curr;
            ++this.pos;
            Item item = this.next();
            if (this.next != null) {
                this.curr = this.next;
                this.next = item;
            } else {
                if (item != null && this.popNext) {
                    this.next = this.next();
                }
                this.curr = item;
            }
            return this.curr != null;
        }

        final boolean findStart(QueryContext qc) throws QueryException {
            while (this.readNext()) {
                if (!Window.this.start.matches(qc, this.curr, this.pos, this.prev, this.next)) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean prepareNext(QueryContext qc, Eval sub) throws QueryException {
            if (!super.prepareNext(qc, sub)) {
                return false;
            }
            this.curr = null;
            this.next = null;
            return true;
        }
    }

    private abstract class WindowEval
    extends Eval {
        private Iter iter;
        Item prev;
        long pos;

        private WindowEval() {
        }

        final Item next() throws QueryException {
            if (this.iter == null) {
                return null;
            }
            Item item = this.iter.next();
            if (item == null) {
                this.iter = null;
            }
            return item;
        }

        boolean prepareNext(QueryContext qc, Eval sub) throws QueryException {
            if (!sub.next(qc)) {
                return false;
            }
            this.iter = Window.this.expr.iter(qc);
            this.prev = null;
            this.pos = 0L;
            return true;
        }
    }
}

