/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.List;
import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.Eval;
import org.basex.query.expr.gflwor.ForLet;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.hash.IntObjMap;

public final class For
extends ForLet {
    Var pos;
    Var score;
    boolean empty;

    public For(Var var, Expr expr) {
        this(var, null, null, expr, false);
    }

    public For(Var var, Var pos, Var score, Expr expr, boolean empty) {
        super(var.info, SeqType.ITEM_ZO, var, expr, score != null, For.vars(var, pos, score));
        this.pos = pos;
        this.score = score;
        this.empty = empty;
    }

    @Override
    Eval eval(final Eval sub) {
        return new Eval(){
            private Iter iter;
            private long p;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean next(QueryContext qc) throws QueryException {
                while (true) {
                    boolean s;
                    Item item = null;
                    if (this.iter != null) {
                        if (For.this.scoring) {
                            s = qc.scoring;
                            try {
                                qc.scoring = true;
                                item = qc.next(this.iter);
                            }
                            finally {
                                qc.scoring = s;
                            }
                        } else {
                            item = qc.next(this.iter);
                        }
                    }
                    if (item != null) {
                        ++this.p;
                        qc.set(For.this.var, item);
                        if (For.this.pos != null) {
                            qc.set(For.this.pos, Int.get(this.p));
                        }
                        if (For.this.score != null) {
                            qc.set(For.this.score, Dbl.get(item.score()));
                        }
                        return true;
                    }
                    if (For.this.empty && this.iter != null && this.p == 0L) {
                        qc.set(For.this.var, Empty.VALUE);
                        if (For.this.pos != null) {
                            qc.set(For.this.pos, Int.get(this.p));
                        }
                        if (For.this.score != null) {
                            qc.set(For.this.score, Dbl.ZERO);
                        }
                        this.iter = null;
                        return true;
                    }
                    if (!sub.next(qc)) {
                        return false;
                    }
                    if (For.this.scoring) {
                        s = qc.scoring;
                        try {
                            qc.scoring = true;
                            this.iter = For.this.expr.iter(qc);
                        }
                        finally {
                            qc.scoring = s;
                        }
                    } else {
                        this.iter = For.this.expr.iter(qc);
                    }
                    this.p = 0L;
                }
            }
        };
    }

    @Override
    public For optimize(CompileContext cc) throws QueryException {
        SeqType st = this.expr.seqType();
        if (st.oneOrMore()) {
            this.empty = false;
        }
        this.exprType.assign(st.with(this.empty ? (st.zero() ? Occ.ZERO : Occ.ZERO_OR_ONE) : Occ.EXACTLY_ONE));
        this.var.refineType(this.seqType(), this.size(), cc);
        this.var.expr(this.expr);
        if (this.pos != null) {
            this.pos.refineType(SeqType.INTEGER_O, 1L, cc);
            this.pos.expr(Int.ZERO);
        }
        if (this.score != null) {
            this.score.refineType(SeqType.DOUBLE_O, 1L, cc);
            this.score.expr(Dbl.ZERO);
        }
        return this;
    }

    @Override
    public For copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new For(cc.copy(this.var, vm), cc.copy(this.pos, vm), cc.copy(this.score, vm), this.expr.copy(cc, vm), this.empty));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return !(!this.expr.accept(visitor) || !visitor.declared(this.var) || this.pos != null && !visitor.declared(this.pos) || this.score != null && !visitor.declared(this.score));
    }

    private static Var[] vars(Var var, Var pos, Var scope) {
        Var[] varArray;
        if (pos == null) {
            if (scope == null) {
                Var[] varArray2 = new Var[1];
                varArray = varArray2;
                varArray2[0] = var;
            } else {
                Var[] varArray3 = new Var[2];
                varArray3[0] = var;
                varArray = varArray3;
                varArray3[1] = scope;
            }
        } else if (scope == null) {
            Var[] varArray4 = new Var[2];
            varArray4[0] = var;
            varArray = varArray4;
            varArray4[1] = pos;
        } else {
            Var[] varArray5 = new Var[3];
            varArray5[0] = var;
            varArray5[1] = pos;
            varArray = varArray5;
            varArray5[2] = scope;
        }
        return varArray;
    }

    boolean asLet(List<Clause> clauses, int p, CompileContext cc) throws QueryException {
        if (!this.expr.seqType().one()) {
            return false;
        }
        clauses.set(p, new Let(this.var, this.expr).optimize(cc));
        if (this.score != null) {
            clauses.add(p + 1, new Let(this.score, new VarRef(this.info(), this.var).optimize(cc), true).optimize(cc));
        }
        if (this.pos != null) {
            clauses.add(p + 1, new Let(this.pos, Int.ONE).optimize(cc));
        }
        return true;
    }

    void remove(CompileContext cc, Var vr) {
        cc.info("remove unused variable: %", vr);
        if (vr == this.score) {
            this.score = null;
            this.scoring = false;
        } else {
            this.pos = null;
        }
        this.vars = For.vars(this.var, this.pos, this.score);
    }

    @Override
    public void calcSize(long[] minMax) {
        long size = this.expr.size();
        long factor = size > 0L ? size : (this.empty ? 1L : 0L);
        minMax[0] = minMax[0] * factor;
        long max = minMax[1];
        if (max > 0L) {
            minMax[1] = size >= 0L ? max * factor : -1L;
        }
    }

    @Override
    Expr inlineExpr(CompileContext cc) {
        return this.empty || this.vars.length > 1 || this.var.checkType() ? null : this.expr;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof For)) {
            return false;
        }
        For f = (For)obj;
        return Objects.equals(this.pos, f.pos) && Objects.equals(this.score, f.score) && this.empty == f.empty && super.equals(obj);
    }

    @Override
    public void toXml(QueryPlan plan) {
        FBuilder elem = plan.attachVariable(plan.create(this, new Object[0]), this.var, false);
        if (this.empty) {
            plan.addAttribute(elem, "empty", true);
        }
        if (this.pos != null) {
            elem.add(plan.create("at", this.pos));
        }
        if (this.score != null) {
            elem.add(plan.create("score", this.score));
        }
        plan.add(elem, this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("for").token(this.var);
        if (this.empty) {
            qs.token("allowing").token("empty");
        }
        if (this.pos != null) {
            qs.token("at").token(this.pos);
        }
        if (this.score != null) {
            qs.token("score").token(this.score);
        }
        qs.token("in").token(this.expr);
    }
}

