/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import java.util.function.Function;
import org.basex.query.expr.ft.ThesEntry;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;

public final class Thesaurus {
    private static final byte[] ENTRY = Token.token("entry");
    private static final byte[] RELATIONSHIP = Token.token("relationship");
    private static final byte[] SYNONYM = Token.token("synonym");
    private static final byte[] TERM = Token.token("term");
    private final TokenObjMap<ThesEntry> entries = new TokenObjMap();
    private static final TokenMap RSHIPS = new TokenMap();

    public Thesaurus(ANode root) {
        for (ANode entry : Thesaurus.elements(root, ENTRY, true)) {
            this.build(entry);
        }
    }

    ThesEntry get(byte[] term) {
        return this.entries.get(term);
    }

    private void build(ANode entry) {
        Function<ANode, ThesEntry> find = node -> {
            byte[] term = Thesaurus.value(node, TERM);
            return this.entries.computeIfAbsent(term, () -> new ThesEntry(term));
        };
        ThesEntry term = find.apply(entry);
        for (ANode synonym : Thesaurus.elements(entry, SYNONYM, false)) {
            ThesEntry syn = find.apply(synonym);
            byte[] value = Thesaurus.value(synonym, RELATIONSHIP);
            term.add(syn, value);
            byte[] rship = RSHIPS.get(value);
            if (rship != null) {
                syn.add(term, rship);
            }
            this.build(synonym);
        }
    }

    private static ANodeList elements(ANode node, byte[] name, boolean desc) {
        ANodeList list = new ANodeList();
        for (ANode element : desc ? node.descendantIter() : node.childIter()) {
            if (element.type != NodeType.ELEMENT || !Token.eq(element.qname().local(), name)) continue;
            list.add(element.finish());
        }
        return list;
    }

    private static byte[] value(ANode node, byte[] name) {
        ANodeList elements = Thesaurus.elements(node, name, false);
        return elements.isEmpty() ? Token.EMPTY : ((ANode)elements.peek()).string();
    }

    static {
        RSHIPS.put("NT", "BT");
        RSHIPS.put("BT", "BT");
        RSHIPS.put("BTG", "NTG");
        RSHIPS.put("NTG", "BTG");
        RSHIPS.put("BTP", "NTP");
        RSHIPS.put("NTP", "BTP");
        RSHIPS.put("USE", "UF");
        RSHIPS.put("UF", "USE");
        RSHIPS.put("RT", "RT");
    }
}

