/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import java.io.IOException;
import java.util.Objects;
import org.basex.io.IO;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.ft.ThesEntry;
import org.basex.query.expr.ft.Thesaurus;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class ThesAccessor {
    private final InputInfo info;
    private final byte[] relation;
    private final long max;
    private Thesaurus thesaurus;
    private IO file;

    public ThesAccessor(IO file) {
        this(file, Token.EMPTY, 0L, Long.MAX_VALUE, null);
    }

    public ThesAccessor(IO file, byte[] relation, long min, long max, InputInfo info) {
        this(relation, min, max, info);
        this.file = file;
    }

    public ThesAccessor(Thesaurus thesaurus, byte[] relation, long max, InputInfo info) {
        this(relation, 0L, max, info);
        this.thesaurus = thesaurus;
    }

    private ThesAccessor(byte[] relation, long min, long max, InputInfo info) {
        this.relation = relation;
        this.max = Math.min(max, min + 100L);
        this.info = info;
    }

    public byte[][] find(byte[] term) throws QueryException {
        TokenList list = new TokenList();
        ThesEntry entry = this.thesaurus().get(term);
        if (entry != null) {
            this.find(list, entry, 0L);
        }
        return (byte[][])list.finish();
    }

    private Thesaurus thesaurus() throws QueryException {
        if (this.thesaurus == null) {
            try {
                this.thesaurus = new Thesaurus(new DBNode(this.file));
            }
            catch (IOException ex) {
                Util.debug(ex);
                throw QueryError.NOTHES_X.get(this.info, this.file);
            }
        }
        return this.thesaurus;
    }

    private void find(TokenList list, ThesEntry entry, long level) {
        if (level >= this.max) {
            return;
        }
        int ns = entry.size;
        for (int n = 0; n < ns; ++n) {
            if (this.relation.length != 0 && !Token.eq(entry.relations[n], this.relation)) continue;
            ThesEntry synonym = entry.synonyms[n];
            byte[] term = synonym.term;
            if (list.contains(term)) continue;
            list.add(term);
            this.find(list, synonym, level + 1L);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ThesAccessor)) {
            return false;
        }
        ThesAccessor ta = (ThesAccessor)obj;
        return Objects.equals(this.file, ta.file) && Objects.equals(this.thesaurus, ta.thesaurus) && Token.eq(this.relation, ta.relation) && this.max == ta.max;
    }

    public String toString() {
        return "\"" + this.file + "\"";
    }
}

