/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTFilter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTStringMatch;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.hash.IntObjMap;

public final class FTWindow
extends FTFilter {
    private Expr win;

    public FTWindow(InputInfo info, FTExpr expr, Expr win, FTUnit unit) {
        super(info, expr, unit);
        this.win = win;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.win);
        super.checkUp();
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        this.win = this.win.compile(cc);
        return super.compile(cc).optimize(cc);
    }

    @Override
    public FTExpr optimize(CompileContext cc) throws QueryException {
        this.win = this.win.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        return this;
    }

    @Override
    protected boolean filter(QueryContext qc, FTMatch match, FTLexer lexer) throws QueryException {
        int n = (int)this.toLong(this.win, qc) - 1;
        match.sort();
        FTStringMatch first = null;
        for (FTStringMatch sm : match) {
            if (sm.exclude) continue;
            if (first == null) {
                first = sm;
            }
            first.gaps = first.gaps | sm.end - first.end > 1;
            first.end = sm.end;
            if (this.pos(first.end, lexer) - this.pos(first.start, lexer) <= n) continue;
            return false;
        }
        if (first == null) {
            return false;
        }
        int w = n - this.pos(first.end, lexer) + this.pos(first.start, lexer);
        for (int s = this.pos(first.start, lexer) - w; s <= this.pos(first.start, lexer); ++s) {
            boolean h = false;
            for (FTStringMatch sm : match) {
                h = sm.exclude && this.pos(sm.start, lexer) >= s && this.pos(sm.end, lexer) <= s + w;
                if (!h) continue;
                break;
            }
            if (h) continue;
            match.reset();
            match.add(first);
            return true;
        }
        return false;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.win.has(flags) || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.win.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.win.count(var).plus(super.count(var));
    }

    @Override
    public FTExpr inline(InlineContext ic) throws QueryException {
        boolean anyInlined = ic.inline(this.exprs);
        Expr inlined = this.win.inline(ic);
        if (inlined != null) {
            this.win = inlined;
        }
        return anyInlined || inlined != null ? this.optimize(ic.cc) : null;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new FTWindow(this.info, (FTExpr)this.exprs[0].copy(cc, (IntObjMap)vm), this.win.copy(cc, vm), this.unit));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.win.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (FTExpr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size + this.win.exprSize();
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[]{"window", this.unit}), new Object[]{this.win, this.exprs});
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.exprs[0]).token("window").token(this.win).token((Object)this.unit);
    }
}

