/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CMap
extends Arr {
    public CMap(InputInfo info, Expr[] expr) {
        super(info, SeqType.MAP_O, expr);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; e += 2) {
            this.exprs[e] = this.exprs[e].simplifyFor(CompileContext.Simplify.DATA, cc);
        }
        if (el == 2) {
            return cc.function(Function._MAP_ENTRY, this.info, this.exprs);
        }
        AtomType kt = null;
        for (int e = 0; e < el; e += 2) {
            SeqType st = this.exprs[e].seqType();
            AtomType type = st.type.atomic();
            if (type == null || !st.one() || st.mayBeArray()) {
                kt = null;
                break;
            }
            kt = kt == null ? type : kt.union(type);
        }
        if (kt == null) {
            kt = AtomType.ANY_ATOMIC_TYPE;
        }
        SeqType dt = null;
        for (int e = 1; e < el; e += 2) {
            SeqType dst = this.exprs[e].seqType();
            dt = dt == null ? dst : dt.union(dst);
        }
        this.exprType.assign(MapType.get(kt, dt != null ? dt : SeqType.ITEM_ZM));
        return this.allAreValues(true) ? cc.preEval(this) : this;
    }

    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        MapBuilder mb = new MapBuilder(this.info);
        int el = this.exprs.length;
        for (int e = 0; e < el; e += 2) {
            Item key = this.toAtomItem(this.exprs[e], qc);
            Value value = this.exprs[e + 1].value(qc);
            if (mb.contains(key)) {
                throw QueryError.MAPDUPLKEY_X_X_X.get(this.info, key, mb.get(key), value);
            }
            mb.put(key, value);
        }
        return mb.map();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CMap(this.info, CMap.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CMap && super.equals(obj);
    }

    @Override
    public String description() {
        return "map";
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("map").token(" { ");
        int el = this.exprs.length;
        for (int e = 0; e < el; e += 2) {
            if (e != 0) {
                qs.token(',');
            }
            qs.token(this.exprs[e]).token(':').token(this.exprs[e + 1]);
        }
        qs.token(" }");
    }
}

