/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CArray
extends Arr {
    private final boolean sequences;

    public CArray(InputInfo info, boolean sequences, Expr ... exprs) {
        super(info, SeqType.ARRAY_O, exprs);
        this.sequences = sequences;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        boolean values = this.allAreValues(true);
        if (this.exprs.length == 1 && (this.sequences || this.exprs[0].size() == 1L)) {
            return cc.replaceWith(this, values ? XQArray.member(this.exprs[0].value(cc.qc)) : cc.function(Function._UTIL_ARRAY_MEMBER, this.info, this.exprs));
        }
        SeqType dt = null;
        if (this.sequences) {
            dt = SeqType.union(this.exprs, true);
        } else {
            for (Expr expr : this.exprs) {
                SeqType st = expr.seqType().with(Occ.EXACTLY_ONE);
                dt = dt == null ? st : dt.union(st);
            }
        }
        if (dt != null) {
            this.exprType.assign(ArrayType.get(dt));
        }
        return this.allAreValues(true) ? cc.preEval(this) : this;
    }

    @Override
    public XQArray item(QueryContext qc, InputInfo ii) throws QueryException {
        ArrayBuilder ab = new ArrayBuilder();
        for (Expr expr : this.exprs) {
            Item item;
            if (this.sequences) {
                ab.append(expr.value(qc));
                continue;
            }
            Iter iter = expr.iter(qc);
            while ((item = qc.next(iter)) != null) {
                ab.append(item);
            }
        }
        return ab.array(this);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode.oneOf(CompileContext.Simplify.STRING, CompileContext.Simplify.NUMBER, CompileContext.Simplify.DATA)) {
            expr = List.get(cc, this.info, this.simplifyAll(mode, cc));
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CArray(this.info, this.sequences, CArray.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CArray && this.sequences == ((CArray)obj).sequences && super.equals(obj);
    }

    @Override
    public String description() {
        return "array";
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.sequences ? "[ " : "array { ").tokens(this.exprs, ", ").token(this.sequences ? " ]" : " }");
    }
}

