/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public class TypeCheck
extends Single {
    final StaticContext sc;
    public final boolean promote;
    private boolean occ;

    public TypeCheck(StaticContext sc, InputInfo info, Expr expr, SeqType seqType, boolean promote) {
        super(info, expr, seqType);
        this.sc = sc;
        this.promote = promote;
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        SeqType st = this.seqType();
        if (st.type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
            this.expr = this.expr.simplifyFor(CompileContext.Simplify.DATA, cc);
        }
        if ((Function.ZERO_OR_ONE.is(this.expr) || Function.EXACTLY_ONE.is(this.expr) || Function.ONE_OR_MORE.is(this.expr)) && st.occ.instanceOf(this.expr.seqType().occ)) {
            this.expr = cc.replaceWith(this.expr, this.expr.arg(0));
        }
        SeqType et = this.expr.seqType();
        boolean bl = this.occ = et.type.instanceOf(st.type) && et.kindInstanceOf(st);
        if (this.expr instanceof TypeCheck) {
            TypeCheck tc = (TypeCheck)this.expr;
            if (this.promote == tc.promote && st.instanceOf(et)) {
                return cc.replaceWith(this, this.get(tc.expr, st).optimize(cc));
            }
        }
        if (et.instanceOf(st)) {
            cc.info("remove % type check: %", st, this.expr);
            return this.expr;
        }
        FuncType ft = this.expr.funcType();
        if (ft != null && this.expr instanceof FuncItem) {
            if (!st.occ.check(1L)) {
                throw this.error(this.expr, st);
            }
            return cc.replaceWith(this, ((FuncItem)this.expr).coerceTo(ft, cc.qc, this.info, true));
        }
        long es = this.expr.size();
        if (this.expr instanceof Value && es <= 262144L) {
            return cc.preEval(this);
        }
        Expr checked = this.expr.typeCheck(this, cc);
        if (checked != null) {
            cc.info("remove % type check: %", st, checked);
            return checked;
        }
        if (!this.expr.seqType().mayBeArray()) {
            Occ o = et.occ.intersect(st.occ);
            if (o == null) {
                throw this.error(this.expr, st);
            }
            this.exprType.assign(st, o, et.occ == st.occ ? es : -1L).data(st.type instanceof NodeType ? this.expr : null);
        }
        return this;
    }

    @Override
    public final Iter iter(final QueryContext qc) throws QueryException {
        final SeqType st = this.seqType();
        final Iter iter = this.expr.iter(qc);
        if (iter.valueIter()) {
            Value value = iter.value(qc, null);
            if (st.instance(value)) {
                return iter;
            }
            if (!this.promote) {
                throw this.error(value, st);
            }
        }
        if (this.occ) {
            return new Iter(){
                int c;

                @Override
                public Item next() throws QueryException {
                    Item item = qc.next(iter);
                    if (item != null ? (long)(++this.c) > st.occ.max : (long)this.c < st.occ.min) {
                        throw TypeCheck.this.error(TypeCheck.this.expr, st);
                    }
                    return item;
                }
            };
        }
        return new Iter(){
            final ItemList items = new ItemList();
            int i;
            int c;

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.i == this.items.size()) {
                    this.items.reset();
                    this.i = 0;
                    item = qc.next(iter);
                    if (item == null || st.instance(item)) {
                        this.items.add(item);
                        continue;
                    }
                    if (!TypeCheck.this.promote) {
                        throw TypeCheck.this.error(TypeCheck.this.expr, st);
                    }
                    st.promote(item, null, this.items, qc, TypeCheck.this.sc, TypeCheck.this.info, false);
                }
                item = (Item)this.items.get(this.i);
                this.items.set(this.i++, null);
                if (item != null ? (long)(++this.c) > st.occ.max : (long)this.c < st.occ.min) {
                    throw TypeCheck.this.error(TypeCheck.this.expr, st);
                }
                return item;
            }
        };
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        Value value = this.expr.value(qc);
        SeqType st = this.seqType();
        if (this.occ) {
            if (!st.occ.check(value.size())) {
                throw this.error(value, st);
            }
            return value;
        }
        if (st.instance(value)) {
            return value;
        }
        if (this.promote) {
            return st.promote(value, null, qc, this.sc, this.info, false);
        }
        throw this.error(value, st);
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return this.promote ? this.simplifyForCast(mode, cc) : super.simplifyFor(mode, cc);
    }

    public final boolean isRedundant(Var var) {
        return (!this.promote || var.promotes()) && var.declaredType().instanceOf(this.seqType());
    }

    public final Expr check(Expr ex, CompileContext cc) throws QueryException {
        SeqType st = this.seqType();
        return ex.seqType().instanceOf(st) ? null : this.get(ex, st).optimize(cc);
    }

    public QueryError error() {
        return this.promote ? QueryError.INVPROMOTE_X_X_X : QueryError.INVTREAT_X_X_X;
    }

    private QueryException error(Expr ex, SeqType st) {
        return QueryError.typeError(ex, st, null, this.info, this.error());
    }

    TypeCheck get(Expr ex, SeqType st) {
        return new TypeCheck(this.sc, this.info, ex, st, this.promote);
    }

    @Override
    public final Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        TypeCheck ex = this.copyType(this.get(this.expr.copy(cc, vm), this.seqType()));
        ex.occ = this.occ;
        return ex;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeCheck)) {
            return false;
        }
        TypeCheck tc = (TypeCheck)obj;
        return this.seqType().eq(tc.seqType()) && this.promote == tc.promote && super.equals(obj);
    }

    @Override
    public final void toXml(QueryPlan plan) {
        FBuilder elem = plan.create(this, "as", this.seqType());
        if (this.promote) {
            plan.addAttribute(elem, "promote", true);
        }
        plan.add(elem, this.expr);
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token("(").token(this.expr);
        if (this.promote) {
            qs.token("promote").token("to");
        } else {
            qs.token("treat").token("as");
        }
        qs.token(this.seqType()).token(')');
    }
}

