/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Catch;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.path.NameTest;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Try
extends Single {
    private Catch[] catches;

    public Try(InputInfo info, Expr expr, Catch[] catches) {
        super(info, expr, SeqType.ITEM_ZM);
        this.catches = catches;
    }

    @Override
    public void checkUp() throws QueryException {
        ExprList exprs = (ExprList)((Object)new ExprList(this.catches.length + 1).add(this.expr));
        for (Catch ctch : this.catches) {
            exprs.add(ctch.expr);
        }
        this.checkAllUp((Expr[])exprs.finish());
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        try {
            super.compile(cc);
        }
        catch (QueryException ex) {
            if (!ex.isCatchable()) {
                throw ex;
            }
            for (Catch ctch : this.catches) {
                if (!ctch.matches(ex)) continue;
                return cc.replaceWith(this, ctch.compile(cc).inline(ex, cc));
            }
            throw ex;
        }
        for (Catch ctch : this.catches) {
            ctch.compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        if (this.expr instanceof Value) {
            return cc.replaceWith(this, this.expr);
        }
        ArrayList<Catch> list = new ArrayList<Catch>();
        ArrayList<NameTest> tests = new ArrayList<NameTest>();
        Checks<Catch> global = Catch::global;
        if (!global.all((Catch[])this.catches)) {
            for (Catch ctch : this.catches) {
                if (!ctch.simplify(tests, cc)) continue;
                list.add(ctch);
            }
            this.catches = (Catch[])list.toArray(Catch[]::new);
        }
        SeqType st = this.expr.seqType();
        for (Catch ctch : this.catches) {
            if (Function.ERROR.is(ctch.expr)) continue;
            st = st.union(ctch.seqType());
        }
        this.exprType.assign(st).data(ExprList.concat(this.catches, this.expr));
        return this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        try {
            return this.expr.value(qc);
        }
        catch (QueryException ex) {
            if (ex.isCatchable()) {
                for (Catch ctch : this.catches) {
                    if (!ctch.matches(ex)) continue;
                    return ctch.value(qc, ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.maximum(var, this.catches).plus(this.expr.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = false;
        CompileContext cc = ic.cc;
        try {
            Expr inlined = this.expr.inline(ic);
            if (inlined != null) {
                if (inlined instanceof Value) {
                    return cc.replaceWith(this, inlined);
                }
                this.expr = inlined;
                changed = true;
            }
        }
        catch (QueryException qe) {
            if (!qe.isCatchable()) {
                throw qe;
            }
            for (Catch ctch : this.catches) {
                if (!ctch.matches(qe)) continue;
                Catch ct = ctch.inline(ic);
                return cc.replaceWith(this, (ct == null ? ctch : ct).inline(qe, cc));
            }
            throw qe;
        }
        for (Catch ctch : this.catches) {
            changed |= ctch.inline(ic) != null;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Try(this.info, this.expr.copy(cc, vm), (Catch[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.catches)));
    }

    @Override
    public boolean vacuous() {
        return this.expr.vacuous() && ((Checks<Catch>)ctch -> ctch.expr.vacuous()).all((Catch[])this.catches);
    }

    @Override
    public boolean ddo() {
        return this.expr.ddo() && ((Checks<Catch>)ctch -> ctch.expr.ddo()).all((Catch[])this.catches);
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Catch ctch : this.catches) {
            if (!ctch.has(flags)) continue;
            return true;
        }
        return super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Catch ctch : this.catches) {
            if (ctch.inlineable(ic)) continue;
            return false;
        }
        return super.inlineable(ic);
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (Catch ctch : this.catches) {
            ctch.markTailCalls(cc);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && Try.visitAll(visitor, this.catches);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Catch ctch : this.catches) {
            size += ctch.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Try && Array.equals(this.catches, ((Try)obj).catches) && super.equals(obj);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.expr, this.catches});
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("try").brace(this.expr).tokens(this.catches);
    }
}

