/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpPos;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IntPos;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

final class SimplePos
extends Arr
implements CmpPos {
    SimplePos(InputInfo info, Expr ... range) {
        super(info, SeqType.BOOLEAN_O, range);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.exprs = this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
        QueryFunction<Expr, Expr> simplify = expr -> {
            ANum num;
            long p;
            if (expr instanceof ANum && !(expr instanceof Int) && (double)(p = (num = (ANum)expr).itr()) == num.dbl()) {
                return Int.get(p);
            }
            return expr;
        };
        this.exprs[0] = simplify.apply(this.exprs[0]);
        this.exprs[1] = simplify.apply(this.exprs[1]);
        Expr min = this.exprs[0];
        Expr max = this.exprs[1];
        Expr ex = null;
        if (this.exact() && (min = (max = min.optimizePos(CmpV.OpV.EQ, cc))) instanceof Bln) {
            ex = min;
        }
        if (ex == null && min instanceof Int && max instanceof Int) {
            ex = IntPos.get(((Int)min).itr(), ((Int)max).itr(), this.info);
        }
        return ex != null ? cc.replaceWith(this, ex) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        this.ctxValue(qc);
        return Bln.get(this.test(qc.focus.pos, qc) != 0);
    }

    @Override
    public SimplePos copy(CompileContext cc, IntObjMap<Var> vm) {
        Expr min = this.exprs[0].copy(cc, vm);
        Expr max = this.exact() ? min : this.exprs[1].copy(cc, vm);
        return this.copyType(new SimplePos(this.info, min, max));
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) throws QueryException {
        if (or || !(ex instanceof SimplePos)) {
            return null;
        }
        SimplePos simplePos = (SimplePos)ex;
        Expr[] posExpr = simplePos.exprs;
        if (!this.exact() && !simplePos.exact()) {
            Expr max;
            Expr min;
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exprs[1];
            Expr expr = expr1 == Int.ONE ? posExpr[0] : (min = posExpr[0] == Int.ONE ? expr1 : null);
            Expr expr3 = expr2 == Int.MAX ? posExpr[1] : (max = posExpr[1] == Int.MAX ? expr2 : null);
            if (min != null && max != null) {
                return new SimplePos(this.info, min, max).optimize(cc);
            }
        }
        return null;
    }

    @Override
    public Expr invert(CompileContext cc) throws QueryException {
        if (this.exprs[0].seqType().one()) {
            Expr pos = cc.function(Function.POSITION, this.info, new Expr[0]);
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exprs[1];
            if (this.exact()) {
                return new CmpG(this.info, pos, expr1, CmpG.OpG.NE, null, cc.sc()).optimize(cc);
            }
            if (expr1 == Int.ONE) {
                return new CmpG(this.info, pos, expr2, CmpG.OpG.GT, null, cc.sc()).optimize(cc);
            }
            if (expr2 == Int.MAX) {
                return new CmpG(this.info, pos, expr1, CmpG.OpG.LT, null, cc.sc()).optimize(cc);
            }
        }
        return null;
    }

    @Override
    public boolean exact() {
        return this.exprs[0] == this.exprs[1];
    }

    @Override
    public int test(long pos, QueryContext qc) throws QueryException {
        double mx;
        Item min = this.exprs[0].atomItem(qc, this.info);
        if (min.isEmpty()) {
            return 0;
        }
        double mn = this.toDouble(min);
        if (this.exact()) {
            mx = mn;
        } else {
            Item max = this.exprs[1].atomItem(qc, this.info);
            if (max.isEmpty()) {
                return 0;
            }
            mx = this.toDouble(max);
        }
        return (double)pos == mx ? 2 : ((double)pos >= mn && (double)pos <= mx ? 1 : 0);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.in(flags) || Flag.CTX.in(flags) || super.has(flags);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode == CompileContext.Simplify.PREDICATE && this.exact() && this.exprs[0].seqType().instanceOf(SeqType.NUMERIC_O) ? this.exprs[0] : this, mode);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SimplePos && super.equals(obj);
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void toString(QueryString qs) {
        qs.function(Function.POSITION, new Object[0]).token("=").token(this.exprs[0]);
        if (!this.exact()) {
            qs.token("to").token(this.exprs[1]);
        }
    }
}

