/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpPos;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.Simple;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class IntPos
extends Simple
implements CmpPos {
    final long min;
    final long max;

    private IntPos(long min, long max, InputInfo info) {
        super(info, SeqType.BOOLEAN_O);
        this.min = min;
        this.max = max;
    }

    public static Expr get(double pos, InputInfo ii) {
        long p = (long)pos;
        return (double)p != pos || p < 1L ? Bln.FALSE : IntPos.get(p, p, ii);
    }

    public static Expr get(long min, long max, InputInfo ii) {
        return min > max || max < 1L ? Bln.FALSE : (min <= 1L && max == Long.MAX_VALUE ? Bln.TRUE : new IntPos(Math.max(1L, min), Math.max(1L, max), ii));
    }

    static Expr get(Expr pos, CmpV.OpV op, InputInfo ii) {
        if (pos == Empty.VALUE) {
            return Bln.FALSE;
        }
        if (pos instanceof RangeSeq && op == CmpV.OpV.EQ) {
            long[] range = ((RangeSeq)pos).range(false);
            return IntPos.get(range[0], range[1], ii);
        }
        if (pos instanceof ANum) {
            ANum num = (ANum)pos;
            long p = num.itr();
            boolean exact = (double)p == num.dbl();
            switch (op) {
                case EQ: {
                    return exact ? IntPos.get(p, p, ii) : Bln.FALSE;
                }
                case GE: {
                    return IntPos.get(exact ? p : p + 1L, Long.MAX_VALUE, ii);
                }
                case GT: {
                    return IntPos.get(p + 1L, Long.MAX_VALUE, ii);
                }
                case LE: {
                    return IntPos.get(1L, p, ii);
                }
                case LT: {
                    return IntPos.get(1L, exact ? p - 1L : p, ii);
                }
                case NE: {
                    return exact ? (p < 2L ? IntPos.get(p + 1L, Long.MAX_VALUE, ii) : null) : Bln.TRUE;
                }
            }
        }
        return null;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        this.ctxValue(qc);
        return Bln.get(this.test(qc.focus.pos, qc) != 0);
    }

    @Override
    public boolean exact() {
        return this.min == this.max;
    }

    @Override
    public int test(long pos, QueryContext qc) {
        return pos == this.max ? 2 : (pos >= this.min && pos <= this.max ? 1 : 0);
    }

    @Override
    public Expr inline(InlineContext ic) {
        return null;
    }

    @Override
    public IntPos copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new IntPos(this.min, this.max, this.info));
    }

    @Override
    public Expr invert(CompileContext cc) throws QueryException {
        if (this.exact()) {
            Expr pos = cc.function(Function.POSITION, this.info, new Expr[0]);
            return new CmpG(this.info, pos, (Expr)Int.get(this.min), CmpG.OpG.NE, null, cc.sc()).optimize(cc);
        }
        return this.min == 1L ? IntPos.get(this.max + 1L, Long.MAX_VALUE, this.info) : (this.max == Long.MAX_VALUE ? IntPos.get(1L, this.min - 1L, this.info) : null);
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) {
        if (!(ex instanceof IntPos)) {
            return null;
        }
        IntPos pos1 = this;
        IntPos pos2 = (IntPos)ex;
        if (pos2.min < pos1.min) {
            pos1 = pos2;
            pos2 = this;
        }
        return !or ? IntPos.get(pos2.min, Math.min(pos1.max, pos2.max), this.info) : (pos1.max + 1L >= pos2.min ? IntPos.get(pos1.min, Math.max(pos1.max, pos2.max), this.info) : null);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.in(flags) || Flag.CTX.in(flags) || super.has(flags);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode == CompileContext.Simplify.PREDICATE && this.exact() ? Int.get(this.min) : this, mode);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntPos)) {
            return false;
        }
        IntPos p = (IntPos)obj;
        return this.min == p.min && this.max == p.max;
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max == Long.MAX_VALUE ? "inf" : Long.valueOf(this.max)), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        qs.function(Function.POSITION, new Object[0]);
        if (this.exact()) {
            qs.token("=").token(this.min);
        } else if (this.max == Long.MAX_VALUE) {
            qs.token(">=").token(this.min);
        } else if (this.min == 1L) {
            qs.token("<=").token(this.max);
        } else {
            qs.token("=").token(this.min).token("to").token(this.max);
        }
    }
}

