/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.StaticContext;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.fn.FnNumber;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

abstract class Convert
extends Single {
    final StaticContext sc;
    final SeqType seqType;

    Convert(StaticContext sc, InputInfo info, Expr expr, SeqType seqType, SeqType targetType) {
        super(info, expr, targetType);
        this.sc = sc;
        this.seqType = seqType;
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.STRING, cc);
        return this;
    }

    final SeqType castType() {
        SeqType est = this.expr.seqType();
        Type type = this.seqType.type;
        Occ occ = this.seqType.occ;
        if (type instanceof ListType) {
            type = type.atomic();
            occ = Occ.ZERO_OR_MORE;
        } else if (occ == Occ.ZERO_OR_ONE && est.oneOrMore() && !est.mayBeArray()) {
            occ = Occ.EXACTLY_ONE;
        }
        return SeqType.get(type, occ);
    }

    final Boolean cast(SeqType castType) {
        SeqType est = this.expr.seqType();
        if (!est.mayBeArray()) {
            long es = this.expr.size();
            if (es != -1L && (es < castType.occ.min || es > castType.occ.max)) {
                return false;
            }
            Type et = est.type;
            if (et.instanceOf(castType.type) && est.occ.instanceOf(castType.occ) && (et.eq(castType.type) || castType.type == AtomType.NUMERIC)) {
                return true;
            }
        }
        return null;
    }

    final Expr simplify(SeqType castType, CompileContext cc) {
        SeqType est = this.expr.seqType();
        Expr arg = null;
        if (est.one() && !est.mayBeArray() && castType.type.instanceOf(AtomType.NUMERIC) && (arg = FnNumber.simplify(this.expr, cc)) == null && this.expr instanceof Cast && (castType.type.instanceOf(est.type) || castType.type.instanceOf(AtomType.INT) && est.type == AtomType.DOUBLE || castType.type.instanceOf(AtomType.SHORT) && est.type == AtomType.FLOAT)) {
            arg = ((Cast)this.expr).expr;
        }
        return arg;
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "as", this.seqType), this.expr);
    }
}

