/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpN
extends Cmp {
    private final OpN op;

    public CmpN(InputInfo info, Expr expr1, Expr expr2, OpN op) {
        super(info, expr1, expr2, null, SeqType.BOOLEAN_ZO, null);
        this.op = op;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        if (st1.oneOrMore() && st2.oneOrMore()) {
            this.exprType.assign(Occ.EXACTLY_ONE);
        }
        return (expr = this.emptyExpr()) == this && this.allAreValues(false) ? cc.preEval(this) : cc.replaceWith(this, expr);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        ANode n1 = this.toNodeOrNull(this.exprs[0], qc);
        if (n1 == null) {
            return Empty.VALUE;
        }
        ANode n2 = this.toNodeOrNull(this.exprs[1], qc);
        if (n2 == null) {
            return Empty.VALUE;
        }
        return Bln.get(this.op.eval(n1, n2));
    }

    @Override
    public Expr invert() {
        return null;
    }

    @Override
    public CmpV.OpV opV() {
        return null;
    }

    @Override
    public CmpG.OpG opG() {
        return null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CmpN(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CmpN && this.op == ((CmpN)obj).op && super.equals(obj);
    }

    @Override
    public String description() {
        return "'" + this.op + "' comparison";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.op.name), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + this.op + " ", true);
    }

    public static enum OpN {
        EQ("is"){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return node1.is(node2);
            }
        }
        ,
        ET("<<"){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return node1.diff(node2) < 0;
            }
        }
        ,
        GT(">>"){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return node1.diff(node2) > 0;
            }
        };

        public static final OpN[] VALUES;
        public final String name;

        private OpN(String name) {
            this.name = name;
        }

        public abstract boolean eval(ANode var1, ANode var2);

        public String toString() {
            return this.name;
        }

        static {
            VALUES = OpN.values();
        }
    }
}

