/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Convert;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Castable
extends Convert {
    public Castable(StaticContext sc, InputInfo info, Expr expr, SeqType seqType) {
        super(sc, info, expr, seqType, SeqType.BOOLEAN_O);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        super.optimize(cc);
        SeqType castType = this.castType();
        Boolean castable = this.cast(castType);
        if (castable != null) {
            return cc.replaceWith(this, Bln.get(castable));
        }
        Expr arg = this.simplify(castType, cc);
        if (arg != null) {
            return new Castable(this.sc, this.info, arg, this.seqType).optimize(cc);
        }
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.seqType.cast(this.expr.atomValue(qc, this.info), false, qc, this.sc, this.info) != null);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Castable(this.sc, this.info, this.expr.copy(cc, vm), this.seqType));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Castable && this.seqType.eq(((Castable)obj).seqType) && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("(").token(this.expr).token("castable").token("as").token(this.seqType).token(')');
    }
}

