/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ann;

import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.ann.Annotation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class Ann {
    public final InputInfo info;
    public final Annotation definition;
    private final QNm name;
    private final Value value;

    public Ann(InputInfo info, Annotation definition, Value value) {
        this.info = info;
        this.value = value;
        this.definition = definition;
        this.name = null;
    }

    public Ann(InputInfo info, QNm name, Value value) {
        this.info = info;
        this.value = value;
        this.name = name;
        this.definition = null;
    }

    public QNm name() {
        return this.definition != null ? this.definition.qname() : this.name;
    }

    public Value value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ann)) {
            return false;
        }
        Ann ann = (Ann)obj;
        return (this.name != null ? ann.name != null && this.name.eq(ann.name) : this.definition == ann.definition) && this.value.equals(ann.value);
    }

    public void toString(QueryString qs) {
        qs.concat("%", this.definition != null ? this.definition.id() : this.name.prefixId(QueryText.XQ_URI));
        if (!this.value.isEmpty()) {
            StringList list = new StringList(this.value.size());
            for (Item item : this.value) {
                list.add(item.toString());
            }
            qs.params(list.finish());
        }
    }

    public String toString() {
        QueryString qs = new QueryString();
        this.toString(qs);
        return qs.toString();
    }
}

