/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.basex.query.CompileContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.scope.MainModule;
import org.basex.query.scope.Scope;
import org.basex.query.scope.StaticDecl;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.FuncItem;
import org.basex.query.var.StaticVar;
import org.basex.util.list.IntList;

final class QueryCompiler {
    private final IntList stack = new IntList();
    private final IntList list = new IntList();
    private int next;
    private final ArrayList<int[]> adjacent = new ArrayList();
    private final ArrayList<Scope> scopes = new ArrayList();
    private final IdentityHashMap<Scope, Integer> ids = new IdentityHashMap();

    QueryCompiler() {
    }

    static List<StaticDecl> usedDecls(MainModule main) {
        final ArrayList<StaticDecl> scopes = new ArrayList<StaticDecl>();
        final IdentityHashMap map = new IdentityHashMap();
        main.visit(new ASTVisitor(){

            @Override
            public boolean staticVar(StaticVar var) {
                if (map.put(var, var) == null) {
                    var.visit(this);
                    scopes.add(var);
                }
                return true;
            }

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                StaticFunc f = call.func();
                if (map.put(f, f) == null) {
                    f.visit(this);
                    scopes.add(f);
                }
                return true;
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                if (map.put(scope, scope) == null) {
                    scope.visit(this);
                }
                return true;
            }

            @Override
            public boolean funcItem(FuncItem func) {
                if (map.put(func, func) == null) {
                    func.visit(this);
                }
                return true;
            }
        });
        return scopes;
    }

    void compile(CompileContext cc) throws QueryException {
        this.add(cc.qc.main);
        ArrayList<StaticFunc> funcs = new ArrayList<StaticFunc>();
        ArrayList<Scope> entries = new ArrayList<Scope>();
        ArrayList<ArrayList<Scope>> iter = this.scopes(0);
        for (ArrayList<Scope> scps : iter) {
            entries.add(QueryCompiler.circCheck(scps));
        }
        for (ArrayList<Scope> scps : iter) {
            for (Scope scope : scps) {
                scope.reset();
            }
        }
        for (Scope scope : entries) {
            scope.compile(cc);
            if (!(scope instanceof StaticFunc)) continue;
            funcs.add((StaticFunc)scope);
        }
        for (StaticVar var : cc.qc.vars) {
            if (this.ids.containsKey(var)) continue;
            for (ArrayList arrayList : this.scopes(this.add(var))) {
                QueryCompiler.circCheck(arrayList);
            }
        }
        for (StaticFunc func : funcs) {
            func.optimize(cc);
        }
    }

    private static Scope circCheck(ArrayList<Scope> scopes) throws QueryException {
        if (scopes.size() > 1) {
            for (Scope scope : scopes) {
                if (!(scope instanceof StaticVar)) continue;
                StaticVar var = (StaticVar)scope;
                throw QueryError.CIRCVAR_X.get(var.info, new Object[]{var.id()});
            }
        }
        return scopes.get(0);
    }

    private ArrayList<ArrayList<Scope>> scopes(int id) throws QueryException {
        ArrayList<ArrayList<Scope>> result = new ArrayList<ArrayList<Scope>>();
        this.tarjan(id, result);
        return result;
    }

    private void tarjan(int id, ArrayList<ArrayList<Scope>> result) throws QueryException {
        int ixv = 2 * id;
        int llv = ixv + 1;
        int idx = this.next++;
        while (this.list.size() <= llv) {
            this.list.add(-1);
        }
        this.list.set(ixv, idx);
        this.list.set(llv, idx);
        this.stack.push(id);
        for (int w : this.adjacentTo(id)) {
            int ixw = 2 * w;
            int llw = ixw + 1;
            if (this.list.size() <= ixw || this.list.get(ixw) < 0) {
                this.tarjan(w, result);
                this.list.set(llv, Math.min(this.list.get(llv), this.list.get(llw)));
                continue;
            }
            if (!this.stack.contains(w)) continue;
            this.list.set(llv, Math.min(this.list.get(llv), this.list.get(ixw)));
        }
        if (this.list.get(llv) == this.list.get(ixv)) {
            int w;
            ArrayList<Scope> out = new ArrayList<Scope>();
            do {
                w = this.stack.pop();
                out.add(this.scopes.get(w));
            } while (w != id);
            result.add(out);
        }
    }

    private int add(Scope scope) {
        int id = this.scopes.size();
        this.scopes.add(scope);
        this.adjacent.add(null);
        this.ids.put(scope, id);
        return id;
    }

    private int[] adjacentTo(int node) throws QueryException {
        int[] adj = this.adjacent.get(node);
        if (adj == null) {
            adj = this.neighbors(this.scopes.get(node));
            this.adjacent.set(node, adj);
        }
        return adj;
    }

    private int[] neighbors(final Scope curr) throws QueryException {
        final IntList neighbors = new IntList(0L);
        boolean ok = curr.visit(new ASTVisitor(){

            @Override
            public boolean staticVar(StaticVar var) {
                return var != curr && this.neighbor(var);
            }

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                return this.neighbor(call.func());
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                return scope.visit(this);
            }

            @Override
            public boolean funcItem(FuncItem func) {
                return this.neighbor(func);
            }

            private boolean neighbor(Scope scope) {
                Integer old = QueryCompiler.this.ids.get(scope);
                if (old == null) {
                    neighbors.add(QueryCompiler.this.add(scope));
                } else if (!neighbors.contains(old)) {
                    neighbors.add((int)old);
                }
                return true;
            }
        });
        if (!ok) {
            StaticVar var = (StaticVar)curr;
            throw QueryError.CIRCREF_X.get(var.info, "$" + var.name);
        }
        return neighbors.finish();
    }
}

