/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.MarkupSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

final class XHTMLSerializer
extends MarkupSerializer {
    XHTMLSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts, "1.0", "1.1");
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        byte[] nm = Token.concat(Token.lc(this.elem.local()), Token.COLON, Token.lc(name));
        byte[] val = this.escuri && HTMLSerializer.URIS.contains(nm) ? Token.escape(value) : value;
        super.attribute(name, val, standalone);
    }

    @Override
    protected void startOpen(QNm value) throws IOException {
        super.startOpen(value);
        if (this.content && Token.eq(Token.lc(this.elem.local()), DataText.HEAD)) {
            ++this.skip;
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        super.finishOpen();
        this.printCT(false, false);
    }

    @Override
    protected void finishEmpty() throws IOException {
        if (this.printCT(true, false)) {
            return;
        }
        byte[] lc = Token.lc(this.elem.local());
        if (this.html5 && HTMLSerializer.EMPTIES5.contains(lc)) {
            this.out.print(DataText.ELEM_SC);
        } else if (!this.html5 && HTMLSerializer.EMPTIES.contains(lc) && Token.eq(this.elem.uri(), DataText.XHTML_URI)) {
            this.out.print(32);
            this.out.print(DataText.ELEM_SC);
        } else {
            this.out.print(DataText.ELEM_C);
            this.sep = false;
            this.finishClose();
        }
    }

    @Override
    protected void doctype(byte[] type) throws IOException {
        if (this.html5 && this.docsys == null) {
            this.printDoctype(type, null, null);
        } else if (this.docsys != null) {
            this.printDoctype(type, this.docpub, this.docsys);
        }
    }

    @Override
    boolean inline() {
        return this.contains(HTMLSerializer.INLINES, this.closed) || this.opening && this.contains(HTMLSerializer.INLINES, this.elem) || super.inline();
    }

    @Override
    boolean suppressIndentation(QNm qname) throws QueryIOException {
        return this.contains(HTMLSerializer.FORMATTEDS, qname) || super.suppressIndentation(qname);
    }

    private boolean contains(TokenSet elements, QNm element) {
        byte[] uri = element.uri();
        byte[] local = element.local();
        return Token.eq(uri, DataText.XHTML_URI) && elements.contains(local) || this.html5 && Token.eq(uri, Token.EMPTY) && elements.contains(Token.lc(local));
    }
}

