/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.util.ArrayList;
import org.basex.data.MetaData;
import org.basex.io.random.TableAccess;
import org.basex.io.random.TableMemBlock;
import org.basex.util.Util;

public final class TableMemAccess
extends TableAccess {
    private final ArrayList<TableMemBlock> blocks = new ArrayList();
    private boolean dense = true;
    private int current;

    public TableMemAccess(MetaData meta) {
        super(meta);
    }

    @Override
    public void flush(boolean all) {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean lock(boolean lock) {
        return true;
    }

    @Override
    public int read1(int pre, int offset) {
        TableMemBlock block = this.block(pre);
        return (int)(block.value(pre, offset) >> ((offset < 8 ? 7 : 15) - offset << 3) & 0xFFL);
    }

    @Override
    public int read2(int pre, int offset) {
        TableMemBlock block = this.block(pre);
        return (int)(block.value(pre, offset) >> ((offset < 8 ? 6 : 14) - offset << 3) & 0xFFFFL);
    }

    @Override
    public int read4(int pre, int offset) {
        TableMemBlock block = this.block(pre);
        return (int)(block.value(pre, offset) >> ((offset < 8 ? 4 : 12) - offset << 3));
    }

    @Override
    public long read5(int pre, int offset) {
        TableMemBlock block = this.block(pre);
        return block.value(pre, offset) >> ((offset < 8 ? 3 : 11) - offset << 3) & 0xFFFFFFFFFFL;
    }

    @Override
    public void write1(int pre, int offset, int value) {
        TableMemBlock block = this.block(pre);
        long d = (long)(offset < 8 ? 7 : 15) - (long)offset << 3;
        block.value(pre, offset, block.value(pre, offset) & (255L << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << (int)d);
    }

    @Override
    public void write2(int pre, int offset, int value) {
        TableMemBlock block = this.block(pre);
        long d = (long)(offset < 8 ? 6 : 14) - (long)offset << 3;
        block.value(pre, offset, block.value(pre, offset) & (65535L << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << (int)d);
    }

    @Override
    public void write4(int pre, int offset, int value) {
        TableMemBlock block = this.block(pre);
        long d = (long)(offset < 8 ? 4 : 12) - (long)offset << 3;
        block.value(pre, offset, block.value(pre, offset) & (0xFFFFFFFFL << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << (int)d);
    }

    @Override
    public void write5(int pre, int offset, long value) {
        TableMemBlock block = this.block(pre);
        long d = (long)(offset < 8 ? 3 : 11) - (long)offset << 3;
        block.value(pre, offset, block.value(pre, offset) & (0xFFFFFFFFFFL << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | value << (int)d);
    }

    @Override
    protected void copy(byte[] entries, int first, int last) {
        int o = 0;
        int pre = first;
        while (pre < last) {
            TableMemBlock block = this.block(pre);
            block.value(pre, 0, TableMemAccess.toLong(entries, o));
            block.value(pre, 8, TableMemAccess.toLong(entries, o + 8));
            ++pre;
            o += 16;
        }
    }

    @Override
    public void delete(int pre, int count) {
        TableMemBlock block = this.block(pre);
        int c = this.current;
        int deleted = 0;
        while (deleted < count) {
            deleted += block.delete(pre, count - deleted, this.firstPre(c + 1) - deleted);
            if (c + 1 < this.blocks.size()) {
                block = this.blocks.get(c + 1);
                block.firstPre -= deleted;
            }
            if (this.firstPre(c) == this.firstPre(c + 1)) {
                this.blocks.remove(c);
                continue;
            }
            ++c;
        }
        this.updateFirstPre(c + 1, -count);
        int size = this.meta.size - count;
        if (pre <= size) {
            this.dense = false;
        } else if (size == 0) {
            this.dense = true;
        }
        this.meta.size = size;
    }

    @Override
    public void insert(int pre, byte[] entries) {
        int count = entries.length >>> 4;
        int size = this.meta.size;
        if (pre == size) {
            int remaining;
            int bs = this.blocks.size();
            int n = remaining = bs == 0 ? 0 : this.blocks.get(bs - 1).remaining(size);
            if (remaining < count) {
                this.blocks.addAll(bs, TableMemBlock.get(count - remaining, pre + remaining));
            }
        } else {
            int c;
            TableMemBlock block = this.block(pre);
            ArrayList<TableMemBlock> list = block.insert(pre, count, this.firstPre(c = this.current + 1));
            if (list != null) {
                this.blocks.addAll(c, list);
                c += list.size();
            }
            this.updateFirstPre(c, count);
            this.dense = false;
        }
        this.meta.size = size += count;
        this.copy(entries, pre, pre + count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Util.className(this));
        sb.append("[size: " + this.meta.size + "; current: " + this.current + "; " + this.blocks.size() + " blocks: ");
        for (TableMemBlock block : this.blocks) {
            sb.append(block.firstPre).append(' ');
        }
        return sb.append(']').toString();
    }

    private TableMemBlock block(int pre) {
        int c;
        if (this.dense) {
            c = pre >>> 12;
        } else {
            c = this.current;
            int fp = this.firstPre(c);
            int np = this.firstPre(c + 1);
            if (pre >= np) {
                fp = np;
                np = this.firstPre(++c + 1);
            } else if (pre < fp) {
                np = fp;
                fp = this.firstPre(--c);
            } else {
                return this.blocks.get(c);
            }
            if (pre >= np || pre < fp) {
                int l = 0;
                int h = this.blocks.size() - 1;
                while (l <= h) {
                    if (pre >= np) {
                        l = c + 1;
                    } else {
                        if (pre >= fp) break;
                        h = c - 1;
                    }
                    c = h + l >>> 1;
                    fp = this.firstPre(c);
                    np = this.firstPre(c + 1);
                }
            }
        }
        this.current = c;
        return this.blocks.get(c);
    }

    private int firstPre(int index) {
        return index < this.blocks.size() ? this.blocks.get((int)index).firstPre : this.meta.size;
    }

    private void updateFirstPre(int index, int count) {
        int bs = this.blocks.size();
        for (int b = index; b < bs; ++b) {
            this.blocks.get((int)b).firstPre += count;
        }
    }

    private static long toLong(byte[] data, int offset) {
        return ((long)data[offset] & 0xFFL) << 56 | ((long)data[offset + 1] & 0xFFL) << 48 | ((long)data[offset + 2] & 0xFFL) << 40 | ((long)data[offset + 3] & 0xFFL) << 32 | ((long)data[offset + 4] & 0xFFL) << 24 | ((long)data[offset + 5] & 0xFFL) << 16 | ((long)data[offset + 6] & 0xFFL) << 8 | (long)data[offset + 7] & 0xFFL;
    }
}

