/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryIOException;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FTxt;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;

final class JsonMLConverter
extends JsonXmlConverter {
    private final TokenSet atts = new TokenSet();

    JsonMLConverter(JsonParserOptions opts) throws QueryIOException {
        super(opts);
    }

    @Override
    FNode finish() {
        return this.doc.add((FBuilder)this.stack.pop()).finish();
    }

    @Override
    void openObject() throws QueryIOException {
        if (this.curr == null || this.name != null || this.stack.peek() != null) {
            JsonMLConverter.error("No object allowed at this stage", new Object[0]);
        }
    }

    @Override
    void closeObject() {
        this.stack.pop();
        this.stack.push(this.curr);
        this.reset();
    }

    @Override
    void openPair(byte[] key, boolean add) throws QueryIOException {
        this.name = this.shared.token(JsonMLConverter.check(key));
        if (!this.atts.add(this.name)) {
            JsonMLConverter.error("Duplicate attribute found", new Object[0]);
        }
    }

    @Override
    void closePair(boolean add) {
    }

    @Override
    void openArray() throws QueryIOException {
        if (!this.stack.isEmpty()) {
            if (this.name == null && this.curr != null && this.stack.peek() == null) {
                this.stack.pop();
                this.stack.push(this.curr);
            } else if (this.name != null || this.curr != null || this.stack.peek() == null) {
                JsonMLConverter.error("No array allowed at this stage", new Object[0]);
            }
        }
        this.stack.push(null);
        this.reset();
    }

    @Override
    void closeArray() throws QueryIOException {
        FBuilder value = (FBuilder)this.stack.pop();
        if (value == null) {
            value = this.curr;
            this.reset();
        }
        if (value == null) {
            JsonMLConverter.error("Missing element name", new Object[0]);
        }
        if (this.stack.isEmpty()) {
            this.stack.push(value);
        } else {
            ((FBuilder)this.stack.peek()).add(value);
        }
    }

    @Override
    void openItem() {
    }

    @Override
    void closeItem() {
    }

    @Override
    void addValue(byte[] type, byte[] value) throws QueryIOException {
        if (this.name == null && this.curr != null && this.stack.peek() == null) {
            this.stack.pop();
            this.stack.push(this.curr);
            this.reset();
        }
        byte[] val = this.shared.token(value);
        if (this.curr == null) {
            FBuilder elem;
            FBuilder fBuilder = elem = this.stack.isEmpty() ? null : (FBuilder)this.stack.peek();
            if (elem == null) {
                this.curr = FElem.build(this.shared.qname(JsonMLConverter.check(val)));
            } else {
                elem.add(new FTxt(val));
            }
        } else if (this.name != null) {
            this.curr.add(this.shared.qname(this.name), val);
            this.name = null;
        } else {
            JsonMLConverter.error("No value allowed at this stage", new Object[0]);
        }
    }

    @Override
    void stringLit(byte[] value) throws QueryIOException {
        this.addValue(JsonConstants.STRING, value);
    }

    @Override
    void numberLit(byte[] value) throws QueryIOException {
        JsonMLConverter.error("No numbers allowed", new Object[0]);
    }

    @Override
    void nullLit() throws QueryIOException {
        JsonMLConverter.error("No 'null' allowed", new Object[0]);
    }

    @Override
    void booleanLit(byte[] b) throws QueryIOException {
        JsonMLConverter.error("No booleans allowed", new Object[0]);
    }

    private void reset() {
        this.curr = null;
        this.atts.clear();
    }

    private static void error(String msg, Object ... ext) throws QueryIOException {
        throw QueryError.JSON_PARSE_X.getIO(Util.info(msg, ext) + ".");
    }

    private static byte[] check(byte[] name) throws QueryIOException {
        if (!XMLToken.isNCName(name)) {
            JsonMLConverter.error("Invalid name: \"%\"", new Object[]{name});
        }
        return name;
    }
}

