/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.csv.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;

public final class CsvXQueryConverter
extends CsvConverter {
    private static final ArrayType STRING_ARRAY = ArrayType.get(SeqType.STRING_O);
    public static final Str NAMES = Str.get("names");
    public static final Str RECORDS = Str.get("records");
    private final ItemList rows = new ItemList();
    private ArrayBuilder row;

    CsvXQueryConverter(CsvParserOptions opts) {
        super(opts);
    }

    @Override
    protected void header(byte[] string) {
        this.headers.add(this.shared.token(string));
    }

    @Override
    protected void record() {
        if (this.row != null) {
            this.rows.add(this.row.array(STRING_ARRAY));
        }
        this.row = new ArrayBuilder();
    }

    @Override
    protected void entry(byte[] value) {
        this.row.append(Str.get(this.shared.token(value)));
    }

    @Override
    protected void init(String uri) {
    }

    @Override
    protected XQMap finish() throws QueryIOException {
        if (this.row != null) {
            this.rows.add(this.row.array(STRING_ARRAY));
        }
        try {
            MapBuilder mb = new MapBuilder();
            if (!this.headers.isEmpty()) {
                ArrayBuilder names = new ArrayBuilder();
                for (byte[] header : this.headers) {
                    names.append(Str.get(header));
                }
                mb.put(NAMES, (Value)names.array(STRING_ARRAY));
            }
            return mb.put(RECORDS, this.rows.value(STRING_ARRAY)).map();
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }
}

