/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnmappableCharacterException;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryError;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class EncoderOutput
extends PrintOutput {
    private final Charset encoding;
    private final CharsetEncoder encoder;
    private final TokenBuilder encbuffer;

    public EncoderOutput(OutputStream os, Charset encoding) {
        super(os);
        this.encoding = encoding;
        this.encoder = encoding.newEncoder();
        this.encbuffer = new TokenBuilder();
    }

    @Override
    public void print(int ch) throws IOException {
        this.encbuffer.reset();
        this.encoder.reset();
        try {
            ByteBuffer bb = this.encoder.encode(CharBuffer.wrap(this.encbuffer.add(ch).toString()));
            this.write(bb.array(), 0, bb.limit());
        }
        catch (UnmappableCharacterException ex) {
            Util.debug(ex);
            throw QueryError.SERENC_X_X.getIO(Integer.toHexString(ch), this.encoding);
        }
        this.lineLength = ch == 10 ? 0L : this.lineLength + 1L;
    }

    @Override
    public void print(byte[] token) throws IOException {
        this.print(Token.string(token));
    }

    @Override
    public void print(String string) throws IOException {
        this.write(string.getBytes(this.encoding));
    }
}

