/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import org.basex.io.in.DecodingException;
import org.basex.io.in.TextInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

abstract class TextDecoder {
    String encoding;
    boolean validate;

    TextDecoder() {
    }

    abstract int read(TextInput var1) throws IOException;

    static TextDecoder get(String enc) throws IOException {
        TextDecoder td = enc == "UTF-8" ? new UTF8() : (enc == "UTF-32" ? new UTF32() : (enc == "UTF-16LE" ? new UTF16LE() : (enc == "UTF-16" || enc == "UTF-16BE" ? new UTF16BE() : new Generic(enc))));
        td.encoding = enc;
        return td;
    }

    final int invalid(boolean incomplete, byte ... bytes) throws IOException {
        if (this.validate) {
            TokenBuilder tb = new TokenBuilder();
            for (byte b : bytes) {
                if (!tb.isEmpty()) {
                    tb.add(", ");
                }
                int c = b >> 4 & 0xF;
                int d = b & 0xF;
                tb.add(c + (c > 9 ? 55 : 48)).add(d + (d > 9 ? 55 : 48));
            }
            if (incomplete) {
                tb.add(", ??");
            }
            throw new DecodingException("Invalid " + this.encoding + " character encoding: " + tb);
        }
        return 65533;
    }

    private static final class Generic
    extends TextDecoder {
        private final byte[] cache = new byte[4];
        private final ByteBuffer inc = ByteBuffer.wrap(this.cache);
        private final CharBuffer outc = CharBuffer.wrap(new char[4]);
        private final CharsetDecoder csd;

        private Generic(String encoding) throws IOException {
            try {
                this.csd = Charset.forName(encoding).newDecoder();
            }
            catch (Exception ex) {
                throw new DecodingException(ex);
            }
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a;
            int c = -1;
            while (++c < 4 && (a = ti.readByte()) >= 0) {
                this.cache[c] = (byte)a;
                this.outc.position(0);
                this.inc.position(0);
                this.inc.limit(c + 1);
                this.csd.reset();
                CoderResult cr = this.csd.decode(this.inc, this.outc, true);
                if (cr.isMalformed()) continue;
                int i = 0;
                int os = this.outc.position();
                for (int o = 0; o < os; ++o) {
                    i |= this.outc.get(o) << (o << 3);
                }
                return i;
            }
            return c == 0 ? -1 : this.invalid(false, this.cache[0]);
        }
    }

    private static class UTF32
    extends TextDecoder {
        private UTF32() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid(true, (byte)a);
            }
            int c = ti.readByte();
            if (c < 0) {
                return this.invalid(true, (byte)a, (byte)b);
            }
            int d = ti.readByte();
            if (d < 0) {
                return this.invalid(true, (byte)a, (byte)b, (byte)c);
            }
            return a << 24 | b << 16 | c << 8 | d;
        }
    }

    private static class UTF16BE
    extends TextDecoder {
        private UTF16BE() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid(true, (byte)a);
            }
            return a << 8 | b;
        }
    }

    private static class UTF16LE
    extends TextDecoder {
        private UTF16LE() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid(true, (byte)a);
            }
            return a | b << 8;
        }
    }

    private static class UTF8
    extends TextDecoder {
        private final byte[] cache = new byte[4];

        private UTF8() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int ch = ti.readByte();
            if (ch < 128) {
                return ch;
            }
            if (ch < 192) {
                return this.invalid(false, (byte)ch);
            }
            this.cache[0] = (byte)ch;
            int cl = Token.cl((byte)ch);
            for (int c = 1; c < cl; ++c) {
                ch = ti.readByte();
                this.cache[c] = (byte)ch;
                if (ch >= 128) continue;
                return this.invalid(ch < 0, Arrays.copyOf(this.cache, ch < 0 ? c : c + 1));
            }
            return Token.cp(this.cache, 0);
        }
    }
}

