/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.transform.stream.StreamSource;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.http.MediaType;
import org.basex.util.http.UserInfo;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public final class IOUrl
extends IO {
    private static final HashMap<Integer, String> REASONS = new HashMap();
    private static SSLContext ssl;
    private static final HttpClient[] CLIENTS;

    public IOUrl(String url) {
        super(IOUrl.normalize(url));
    }

    @Override
    public byte[] read() throws IOException {
        return BufferInput.get(this).content();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.pth);
    }

    @Override
    public StreamSource streamSource() {
        return new StreamSource(this.pth);
    }

    @Override
    public InputStream inputStream() throws IOException {
        return IOUrl.isJarURL(this.pth) ? new URL(this.pth).openStream() : this.response().body();
    }

    public HttpResponse<InputStream> response() throws IOException {
        HttpResponse<InputStream> response;
        HttpClient client = IOUrl.client(true);
        try {
            URI uri = new URI(this.pth);
            HttpRequest.Builder rb = HttpRequest.newBuilder(uri).timeout(Duration.ofMinutes(1L));
            rb.header("Accept", MediaType.ALL_ALL.toString());
            new UserInfo(uri).basic(rb);
            response = client.send(rb.build(), HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Util.debug(ex);
            throw new IOException(ex.getMessage());
        }
        int status = response.statusCode();
        if (status >= 400) {
            StringBuilder sb = new StringBuilder().append(status);
            String reason = IOUrl.reason(status);
            if (!reason.isEmpty()) {
                sb.append(": ").append(reason);
            }
            throw new IOException(sb.toString());
        }
        return response;
    }

    public static HttpClient client(boolean redirect) {
        int i;
        int n = i = redirect ? 1 : 0;
        if (CLIENTS[i] == null) {
            HttpClient.Builder cb = HttpClient.newBuilder();
            if (ssl != null) {
                cb.sslContext(ssl).connectTimeout(Duration.ofMinutes(1L));
            }
            IOUrl.CLIENTS[i] = cb.followRedirects(redirect ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER).build();
        }
        return CLIENTS[i];
    }

    public static String reason(int status) {
        String reason = REASONS.get(status);
        return reason != null ? reason : "";
    }

    static boolean isValid(String url) {
        int ul = url.length();
        int u = url.indexOf(58);
        if (u < 2 || u + 1 == ul) {
            return false;
        }
        if (!IOUrl.isJarURL(url) && url.charAt(u + 1) != '/') {
            return false;
        }
        while (--u >= 0) {
            char c = url.charAt(u);
            if (c >= 'a' && c <= 'z' || c == '+' || c == '-' || c == '.' || c == '_') continue;
            return false;
        }
        return true;
    }

    static String toFile(String uri) {
        try {
            String path = Paths.get(new URI(uri)).toString();
            return Strings.endsWith(uri, '/') || Strings.endsWith(uri, '\\') ? path + File.separator : path;
        }
        catch (Exception ex) {
            Util.errln(ex, new Object[0]);
            return uri;
        }
    }

    static boolean isFileURL(String url) {
        return url.startsWith("file:/");
    }

    static boolean isJarURL(String url) {
        return url.startsWith("jar:");
    }

    public static void ignoreCertificates() {
        System.getProperties().setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
        try {
            ssl = SSLContext.getInstance("TLS");
            ssl.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509, String type) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509, String type) {
                }
            }}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            Util.stack(ex);
        }
    }

    private static String normalize(String string) {
        int i = string.indexOf("://") + 3;
        if (i == 2) {
            return string;
        }
        String scheme = string.substring(0, i);
        String path = string.substring(i);
        String query = "";
        String anchor = "";
        i = path.indexOf(35);
        if (i != -1) {
            anchor = path.substring(i);
            path = path.substring(0, i);
        }
        if ((i = path.indexOf(63)) != -1) {
            query = path.substring(i);
            path = path.substring(0, i);
        }
        StringList segments = new StringList(Strings.split(path, '/'));
        for (int s = 1; s < segments.size(); ++s) {
            String segment = (String)segments.get(s);
            if (segment.equals(".")) {
                segments.remove(s--);
                continue;
            }
            if (!segment.equals("..") || s <= 1) continue;
            segments.remove(s--);
            segments.remove(s--);
        }
        return scheme + String.join((CharSequence)"/", (CharSequence[])segments.finish()) + query + anchor;
    }

    static {
        CLIENTS = new HttpClient[2];
        REASONS.put(100, "Continue");
        REASONS.put(101, "Switching Protocols");
        REASONS.put(102, "Processing");
        REASONS.put(200, "OK");
        REASONS.put(201, "Created");
        REASONS.put(202, "Accepted");
        REASONS.put(203, "Non-Authoritative Information");
        REASONS.put(204, "No Content");
        REASONS.put(205, "Reset Content");
        REASONS.put(206, "Partial Content");
        REASONS.put(207, "Multi-Status");
        REASONS.put(208, "Already Reported");
        REASONS.put(300, "Multiple Choices");
        REASONS.put(301, "Moved Permanently");
        REASONS.put(302, "Found");
        REASONS.put(303, "See Other");
        REASONS.put(304, "Not Modified");
        REASONS.put(305, "Use Proxy");
        REASONS.put(307, "Temporary Redirect");
        REASONS.put(308, "Permanent Redirect");
        REASONS.put(400, "Bad Request");
        REASONS.put(401, "Unauthorized");
        REASONS.put(402, "Payment Required");
        REASONS.put(403, "Forbidden");
        REASONS.put(404, "Not Found");
        REASONS.put(405, "Method Not Allowed");
        REASONS.put(406, "Not Acceptable");
        REASONS.put(407, "Proxy Authentication Required");
        REASONS.put(408, "Request Timeout");
        REASONS.put(409, "Conflict");
        REASONS.put(410, "Gone");
        REASONS.put(411, "Length Required");
        REASONS.put(412, "Precondition Failed");
        REASONS.put(413, "Payload Too Large");
        REASONS.put(414, "Request-URI Too Long");
        REASONS.put(415, "Unsupported Media Type");
        REASONS.put(416, "Requested Range Not Satisfiable");
        REASONS.put(417, "Expectation Failed");
        REASONS.put(418, "I'm a teapot");
        REASONS.put(420, "Enhance Your Calm");
        REASONS.put(421, "Misdirected Request");
        REASONS.put(422, "Unprocessable Entity");
        REASONS.put(423, "Locked");
        REASONS.put(424, "Failed Dependency");
        REASONS.put(426, "Upgrade Required");
        REASONS.put(428, "Precondition Required");
        REASONS.put(429, "Too Many Requests");
        REASONS.put(431, "Request Header Fields Too Large");
        REASONS.put(444, "Connection Closed Without Response");
        REASONS.put(451, "Unavailable For Legal Reasons");
        REASONS.put(499, "Client Closed Request");
        REASONS.put(500, "Internal Server Error");
        REASONS.put(501, "Not Implemented");
        REASONS.put(502, "Bad Gateway");
        REASONS.put(503, "Service Unavailable");
        REASONS.put(504, "Gateway Timeout");
        REASONS.put(505, "HTTP Version Not Supported");
        REASONS.put(506, "Variant Also Negotiates");
        REASONS.put(507, "Insufficient Storage");
        REASONS.put(508, "Loop Detected");
        REASONS.put(510, "Not Extended");
        REASONS.put(511, "Network Authentication Required");
        REASONS.put(599, "Network Connect Timeout Error");
    }
}

