/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.resource;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.index.Index;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexSearch;
import org.basex.index.resource.Binaries;
import org.basex.index.resource.Docs;
import org.basex.index.resource.ResourceType;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.util.index.IndexCosts;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class Resources
implements Index {
    public static final ResourceType[] BINARIES = new ResourceType[]{ResourceType.BINARY, ResourceType.VALUE};
    private final Docs docs;
    private final Binaries bins;

    public Resources(Data data) {
        this.docs = new Docs(data);
        this.bins = new Binaries(data);
    }

    public synchronized void read(DataInput in) throws IOException {
        this.docs.read(in);
    }

    public void write(DataOutput out) throws IOException {
        this.docs.write(out);
    }

    public synchronized IntList docs() {
        return this.docs.docs();
    }

    public void insert(int pre, DataClip clip) {
        this.docs.insert(pre, clip);
    }

    public void delete(int pre, int size) {
        this.docs.delete(pre, size);
    }

    public void rename(int pre, byte[] value) {
        this.docs.rename(pre, value);
    }

    public synchronized IntList docs(String path) {
        return this.docs(path, false);
    }

    public synchronized IntList docs(String path, boolean dir) {
        return this.docs.docs(path, dir);
    }

    public int doc(String path) {
        return this.docs.doc(path);
    }

    public synchronized StringList paths(String path, ResourceType type) {
        return this.bins.paths(path, type);
    }

    public synchronized boolean isDir(String path) {
        return this.docs.isDir(path) || this.bins.isDir(path, ResourceType.BINARY) || this.bins.isDir(path, ResourceType.VALUE);
    }

    public synchronized TokenObjMap<ResourceType> children(String path, boolean dir) {
        TokenObjMap<ResourceType> map = new TokenObjMap<ResourceType>();
        this.docs.children(path, dir, map);
        this.bins.children(path, dir, map);
        return map;
    }

    @Override
    public boolean drop() {
        throw Util.notExpected();
    }

    @Override
    public void close() {
    }

    @Override
    public IndexIterator iter(IndexSearch search) {
        throw Util.notExpected();
    }

    @Override
    public IndexCosts costs(IndexSearch search) {
        throw Util.notExpected();
    }

    @Override
    public byte[] info(MainOptions options) {
        throw Util.notExpected();
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        throw Util.notExpected();
    }
}

