/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.resource;

import java.util.Locale;
import org.basex.io.IOFile;
import org.basex.util.http.MediaType;

public enum ResourceType {
    XML{

        @Override
        public IOFile dir(IOFile dbpath) {
            return null;
        }

        @Override
        public MediaType contentType(String path) {
            MediaType ct = MediaType.get(path);
            return !ct.isXml() ? MediaType.APPLICATION_XML : ct;
        }
    }
    ,
    BINARY{

        @Override
        public IOFile dir(IOFile dbpath) {
            return new IOFile(dbpath, "raw");
        }

        @Override
        public MediaType contentType(String path) {
            return MediaType.get(path);
        }
    }
    ,
    VALUE{

        @Override
        public IOFile dir(IOFile dbpath) {
            return new IOFile(dbpath, "values");
        }

        @Override
        public MediaType contentType(String path) {
            return MediaType.get(path);
        }

        @Override
        public String dbPath(String path) {
            return path.substring(0, path.length() - ".basex".length());
        }

        @Override
        public IOFile filePath(IOFile root, String path) {
            return new IOFile(root, path + ".basex");
        }
    };


    public abstract IOFile dir(IOFile var1);

    public String dbPath(String path) {
        return path;
    }

    public IOFile filePath(IOFile root, String path) {
        return new IOFile(root, path);
    }

    public abstract MediaType contentType(String var1);

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }
}

