/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.resource;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.DataText;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class Docs {
    private final Data data;
    private IntList docList;
    private TokenList pathList;
    private int[] pathOrder;
    private boolean dirty;
    private boolean pathIndex;

    Docs(Data data) {
        this.data = data;
    }

    synchronized void read(DataInput in) throws IOException {
        this.docList = in.readDiffs();
        this.pathIndex = this.data.meta.dbFile("pth").exists();
    }

    void write(DataOutput out) throws IOException {
        out.writeDiffs(this.docs());
        if (this.dirty && this.pathIndex) {
            TokenList paths = this.paths();
            try (DataOutput doc = new DataOutput(this.data.meta.dbFile("pth"));){
                doc.writeNum(paths.size());
                for (byte[] path : paths) {
                    doc.writeToken(path);
                }
            }
            this.dirty = false;
        }
    }

    synchronized IntList docs() {
        if (this.docList == null) {
            int k;
            IntList pres = new IntList();
            int is = this.data.meta.size;
            for (int pre = 0; pre < is; pre += this.data.size(pre, k)) {
                k = this.data.kind(pre);
                if (k != 0) continue;
                pres.add(pre);
            }
            this.update();
            this.docList = pres;
        }
        return this.docList;
    }

    private synchronized TokenList paths() {
        if (this.pathList == null && this.pathIndex) {
            try (DataInput in = new DataInput(this.data.meta.dbFile("pth"));){
                this.pathList = new TokenList(in.readTokens());
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        if (this.pathList == null) {
            IntList docs = this.docs();
            int ds = docs.size();
            TokenList paths = new TokenList(ds);
            for (int d = 0; d < ds; ++d) {
                paths.add(Docs.normalize(this.data.text(docs.get(d), true)));
            }
            this.pathIndex = true;
            this.pathList = paths;
            this.update();
        }
        return this.pathList;
    }

    private synchronized int[] order() {
        if (this.pathOrder == null) {
            this.pathOrder = Array.createOrder((byte[][])this.paths().toArray(), false, true);
        }
        return this.pathOrder;
    }

    void insert(int pre, DataClip clip) {
        int k;
        IntList il = new IntList();
        Data src = clip.data;
        for (int dpre = clip.start; dpre < clip.end; dpre += src.size(dpre, k)) {
            k = src.kind(dpre);
            if (k != 0) continue;
            il.add(pre + dpre);
        }
        int[] pres = il.finish();
        int ps = pres.length;
        IntList docs = this.docs();
        int i = docs.sortedIndexOf(pre);
        if (i < 0) {
            i = -i - 1;
        }
        if (this.pathIndex) {
            TokenList paths = this.paths();
            byte[][] tmp = new byte[ps][];
            for (int t = 0; t < ps; ++t) {
                tmp[t] = Docs.normalize(clip.data.text(pres[t] - pre, true));
            }
            paths.insert(i, (E[])tmp);
        }
        docs.insert(i, pres);
        docs.incFrom(clip.size(), i + ps);
        this.update();
    }

    void delete(int pre, int size) {
        IntList docs = this.docs();
        int doc = docs.sortedIndexOf(pre);
        if (doc >= 0) {
            if (this.pathIndex) {
                this.paths().remove(doc);
            }
            docs.remove(doc);
        }
        docs.incFrom(-size, doc < 0 ? -doc - 1 : doc);
        this.update();
    }

    void rename(int pre, byte[] value) {
        if (this.pathIndex) {
            this.paths().set(this.docs().sortedIndexOf(pre), Docs.normalize(value));
        }
        this.update();
    }

    private synchronized void update() {
        this.pathOrder = null;
        this.data.meta.dirty = true;
        this.dirty = true;
    }

    synchronized IntList docs(String path, boolean dir) {
        String pth = MetaData.normPath(path);
        if (pth == null) {
            return new IntList(0L);
        }
        IntList docs = this.docs();
        if (!dir && pth.isEmpty()) {
            return docs;
        }
        byte[] exact = Token.EMPTY;
        byte[] prefix = Docs.normalize(Token.token(pth));
        if (!pth.isEmpty() && !Strings.endsWith(pth, '/')) {
            exact = prefix;
            prefix = Token.concat(exact, Token.SLASH);
        }
        TokenSet set = new TokenSet();
        IntList il = new IntList();
        TokenList paths = this.paths();
        int ps = paths.size();
        for (int p = 0; p < ps; ++p) {
            int i;
            byte[] pt = (byte[])paths.get(p);
            boolean add = Token.eq(pt, exact);
            if (!add && (add = Token.startsWith(pt, prefix)) && dir && (i = Token.indexOf(pt, Token.SLASH, prefix.length + 1)) != -1) {
                add = set.add(Token.substring(pt, prefix.length, i));
            }
            if (!add) continue;
            il.add(docs.get(p));
        }
        return il.sort();
    }

    synchronized int doc(String path) {
        String pth = MetaData.normPath(path);
        if (pth != null && !pth.isEmpty()) {
            byte[] npth = Docs.normalize(Token.token(pth));
            TokenList paths = this.paths();
            int[] order = this.order();
            int l = 0;
            int h = order.length - 1;
            while (l <= h) {
                int m = l + h >>> 1;
                int o = order[m];
                int c = Token.diff((byte[])paths.get(o), npth);
                if (c == 0) {
                    return this.docs().get(o);
                }
                if (c < 0) {
                    l = m + 1;
                    continue;
                }
                h = m - 1;
            }
        }
        return -1;
    }

    synchronized boolean isDir(String path) {
        byte[] prefix = Token.concat(path, Token.SLASH);
        for (byte[] pth : this.paths()) {
            if (!Token.startsWith(pth, prefix)) continue;
            return true;
        }
        return false;
    }

    synchronized void children(String path, boolean dir, TokenObjMap<ResourceType> map) {
        String pth = MetaData.normPath(path);
        if (pth == null) {
            return;
        }
        byte[] root = Token.token(pth);
        if (root.length != 0) {
            root = Token.concat(root, Token.SLASH);
        }
        IntList docs = this.docs();
        int ds = docs.size();
        for (int d = 0; d < ds; ++d) {
            byte[] np = this.data.text(docs.get(d), true);
            if (!Token.startsWith(np, root)) continue;
            np = Token.substring(np, root.length, np.length);
            int i = Token.indexOf(np, Token.SLASH);
            if (!dir && i == -1) {
                map.put(np, ResourceType.XML);
                continue;
            }
            if (!dir || i < 0) continue;
            map.put(Token.substring(np, 0, i), ResourceType.XML);
        }
    }

    private static byte[] normalize(byte[] path) {
        return Token.concat(Token.SLASH, Prop.CASE ? path : Token.lc(path));
    }

    public String toString() {
        Table table = new Table();
        table.header.add(DataText.TABLEPRE);
        table.header.add(DataText.TABLECON);
        TokenList tl = new TokenList();
        int ds = this.paths().size();
        for (int d = 0; d < ds; ++d) {
            int doc = this.docList != null ? this.docList.get(d) : 0;
            byte[] path = this.pathList != null ? (byte[])this.pathList.get(d) : Token.EMPTY;
            table.contents.add((TokenList)tl.add(doc).add(path));
        }
        return table.toString();
    }
}

