/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.query;

import org.basex.index.query.IndexIterator;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.util.ft.FTStringMatch;
import org.basex.util.list.IntList;

public abstract class FTIndexIterator
implements IndexIterator {
    public static final FTIndexIterator FTEMPTY = new FTIndexIterator(){

        @Override
        public boolean more() {
            return false;
        }

        @Override
        public int pre() {
            return 0;
        }

        @Override
        public FTMatches matches() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void pos(int p) {
        }
    };

    public abstract FTMatches matches();

    public abstract void pos(int var1);

    public static FTIndexIterator union(final FTIndexIterator ... iters) {
        return new FTIndexIterator(){
            final IntList curr = new IntList();
            FTIndexIterator[] ir;

            @Override
            public boolean more() {
                int il = iters.length;
                if (this.ir == null) {
                    this.ir = new FTIndexIterator[il];
                    for (int i = 0; i < il; ++i) {
                        this.ir[i] = iters[i].more() ? iters[i] : null;
                    }
                } else {
                    int cs = this.curr.size();
                    for (int c = 0; c < cs; ++c) {
                        int i = this.curr.get(c);
                        if (this.ir[i].more()) continue;
                        this.ir[i] = null;
                    }
                }
                int pre = Integer.MAX_VALUE;
                for (int i = 0; i < il; ++i) {
                    int p;
                    if (this.ir[i] == null || pre < (p = this.ir[i].pre())) continue;
                    if (pre > p) {
                        pre = p;
                        this.curr.reset();
                    }
                    this.curr.add(i);
                }
                return pre < Integer.MAX_VALUE;
            }

            @Override
            public FTMatches matches() {
                FTMatches all = this.ir[this.curr.get(0)].matches();
                int cs = this.curr.size();
                for (int c = 1; c < cs; ++c) {
                    for (FTMatch match : this.ir[this.curr.get(c)].matches()) {
                        int s = ((FTStringMatch[])match.list)[0].start;
                        int i = all.size();
                        while (--i >= 0 && s < ((FTStringMatch[])((FTMatch)all.get((int)i)).list)[0].start) {
                        }
                        all.insert(++i, match);
                    }
                }
                return all;
            }

            @Override
            public int pre() {
                return this.ir[this.curr.peek()].pre();
            }

            @Override
            public void pos(int p) {
                for (FTIndexIterator iter : iters) {
                    iter.pos(p);
                }
            }

            @Override
            public synchronized int size() {
                int c = 0;
                for (FTIndexIterator iter : iters) {
                    c += iter.size();
                }
                return c;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder().append('(');
                for (FTIndexIterator iter : iters) {
                    if (sb.length() > 1) {
                        sb.append(" | ");
                    }
                    sb.append(iter);
                }
                return sb.append(')').toString();
            }
        };
    }

    public static FTIndexIterator intersect(final FTIndexIterator i1, final FTIndexIterator i2, final int dis) {
        return new FTIndexIterator(){
            private FTIndexIterator ii1;
            private FTIndexIterator ii2;
            private FTMatches all;

            @Override
            public boolean more() {
                int d = 0;
                while (true) {
                    if (d <= 0) {
                        FTIndexIterator fTIndexIterator = this.ii1 = i1.more() ? i1 : null;
                    }
                    if (d >= 0) {
                        FTIndexIterator fTIndexIterator = this.ii2 = i2.more() ? i2 : null;
                    }
                    if (this.ii1 == null || this.ii2 == null) {
                        return false;
                    }
                    d = this.ii1.pre() - this.ii2.pre();
                    if (d != 0) continue;
                    this.all = this.ii1.matches();
                    FTMatches all2 = this.ii2.matches();
                    if (dis == 0) {
                        for (FTMatch m1 : this.all) {
                            for (FTMatch m2 : all2) {
                                m1.add(m2);
                            }
                        }
                        return true;
                    }
                    if (this.all.phrase(all2, dis)) break;
                }
                return true;
            }

            @Override
            public FTMatches matches() {
                return this.all;
            }

            @Override
            public int pre() {
                return this.ii1.pre();
            }

            @Override
            public void pos(int p) {
                i1.pos(p);
                i2.pos(p);
            }

            @Override
            public synchronized int size() {
                return Math.min(i1.size(), i2.size());
            }

            public String toString() {
                return "(" + i1 + " & " + i2 + ")";
            }
        };
    }
}

