/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.path;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.Index;
import org.basex.index.path.PathNode;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexSearch;
import org.basex.index.stats.Stats;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.util.index.IndexCosts;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class PathIndex
implements Index {
    private final ArrayList<PathNode> stack = new ArrayList();
    private Data data;
    private PathNode root;

    public PathIndex() {
        this.init();
    }

    public PathIndex(Data data) {
        this();
        this.data = data;
    }

    public PathIndex(Data data, DataInput in) throws IOException {
        this.root = in.readBool() ? new PathNode(in, null) : new PathNode();
        this.data = data;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBool(this.root != null);
        if (this.root != null) {
            this.root.write(out, this.data.meta);
        }
    }

    public void data(Data dt) {
        this.data = dt;
    }

    public void init() {
        this.root = new PathNode();
        this.stack.clear();
        this.stack.add(this.root);
    }

    @Override
    public void close() {
    }

    public void index(int name, byte kind, int level) {
        this.index(name, kind, level, null, null);
    }

    public void index(int name, byte kind, int level, byte[] value, MetaData meta) {
        if (level == 0) {
            Stats stats = this.root.stats;
            if (value != null) {
                stats.add(value, meta);
            }
            ++stats.count;
        } else {
            while (level >= this.stack.size()) {
                this.stack.add(null);
            }
            this.stack.set(level, this.stack.get(level - 1).index(name, kind, value, meta));
        }
    }

    public ArrayList<PathNode> root() {
        ArrayList<PathNode> out = new ArrayList<PathNode>();
        out.add(this.root);
        return out;
    }

    public static ArrayList<PathNode> parent(ArrayList<PathNode> nodes) {
        ArrayList<PathNode> out = new ArrayList<PathNode>();
        for (PathNode node : nodes) {
            if (out.contains(node.parent)) continue;
            out.add(node.parent);
        }
        return out;
    }

    public static ArrayList<PathNode> desc(ArrayList<PathNode> nodes, boolean desc) {
        ArrayList<PathNode> list = new ArrayList<PathNode>();
        for (PathNode node : nodes) {
            for (PathNode child : node.children) {
                if (desc) {
                    child.addDesc(list);
                    continue;
                }
                if (list.contains(child)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public ArrayList<PathNode> desc(byte[] name) {
        int id = this.data.elemNames.id(name);
        ArrayList<PathNode> list = new ArrayList<PathNode>();
        for (PathNode child : this.root.children) {
            child.addDesc(list, id);
        }
        return list;
    }

    public TokenList desc(byte[] name, boolean desc, boolean occ) {
        TokenList names = new TokenList();
        if (name.length != 0) {
            names.add(name);
        }
        return this.desc(names, desc, occ);
    }

    public TokenList desc(TokenList names, boolean desc, boolean occ) {
        ArrayList<PathNode> nodes = PathIndex.desc(this.root(), true);
        for (byte[] name : names) {
            boolean attr = Token.startsWith(name, 64);
            byte kind = attr ? (byte)3 : 1;
            int id = attr ? this.data.attrNames.id(Token.substring(name, 1)) : this.data.elemNames.id(name);
            ArrayList<PathNode> list = new ArrayList<PathNode>();
            for (PathNode node : nodes) {
                if (node.name != id || node.kind != kind) continue;
                for (PathNode child : node.children) {
                    if (desc) {
                        child.addDesc(list);
                        continue;
                    }
                    list.add(child);
                }
            }
            nodes = list;
        }
        int ns = nodes.size();
        int[] tmp = new int[ns];
        for (int i = 0; i < ns; ++i) {
            tmp[i] = nodes.get((int)i).stats.count;
        }
        int[] occs = Array.createOrder(tmp, false);
        TokenList tl = new TokenList();
        for (int n = 0; n < ns; ++n) {
            PathNode node = nodes.get(occ ? occs[n] : n);
            byte[] name = node.token(this.data);
            if (name.length == 0 || tl.contains(name) || Token.contains(name, 40)) continue;
            tl.add(name);
        }
        if (!occ) {
            tl.sort(false);
        }
        return tl;
    }

    @Override
    public byte[] info(MainOptions options) {
        return this.root != null ? Token.chop(this.root.info(this.data, 0), 0x100000) : Token.EMPTY;
    }

    @Override
    public boolean drop() {
        throw Util.notExpected();
    }

    @Override
    public IndexIterator iter(IndexSearch search) {
        throw Util.notExpected();
    }

    @Override
    public IndexCosts costs(IndexSearch search) {
        throw Util.notExpected();
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        throw Util.notExpected();
    }

    public String toString() {
        return Token.string(this.info(null));
    }
}

