/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.tree;

import java.awt.Graphics;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.tree.TreeRect;
import org.basex.gui.view.tree.TreeSubtree;
import org.basex.query.value.seq.DBNodes;

final class TreeRects {
    private final View view;
    private TreeRect[][][] rects;
    DBNodes nodes;
    Graphics g;

    TreeRects(View view) {
        this.view = view;
    }

    double generateRects(TreeSubtree sub, int ds, int dw, boolean slim) {
        int[] roots = this.nodes.pres();
        int rl = roots.length;
        if (rl == 0) {
            return 0.0;
        }
        double w = (double)(dw - 2 - ds) / (double)rl;
        if (w < 2.0) {
            return -1.0;
        }
        this.rects = new TreeRect[rl][][];
        for (int i = 0; i < rl; ++i) {
            this.generateRects(sub, i, ds, w, slim);
        }
        return w;
    }

    private void generateRects(TreeSubtree sub, int rn, int ds, double dw, boolean slim) {
        int h = sub.subtreeHeight(rn);
        this.rects[rn] = new TreeRect[h][];
        for (int lv = 0; lv < h; ++lv) {
            double w = dw / (double)sub.levelSize(rn, lv);
            if (w < 2.0) {
                this.bigRectangle(rn, lv, ds, dw);
                continue;
            }
            this.normalRectangle(sub, rn, lv, ds, w, slim);
        }
    }

    private void bigRectangle(int rn, int lv, int ds, double w) {
        this.rects[rn][lv] = new TreeRect[1];
        this.rects[rn][lv][0] = new TreeRect((int)(w * (double)rn) + 2 + ds, (int)w - 2);
    }

    private void normalRectangle(TreeSubtree sub, int rn, int lv, int ds, double w, boolean slim) {
        int subSi = sub.levelSize(rn, lv);
        this.rects[rn][lv] = new TreeRect[subSi];
        double xx = (double)rn * w * (double)subSi + (double)ds;
        double ww = w;
        for (int i = 0; i < subSi; ++i) {
            if (slim) {
                double boxMiddle = xx + ww / 2.0;
                byte[] text = this.text(sub.prePerIndex(rn, lv, i));
                int o = this.calcOptimalRectWidth(text) + 10;
                if (o < 4) {
                    o = 4;
                }
                if (w > (double)o) {
                    xx = boxMiddle - (double)o / 2.0;
                    ww = o;
                }
            }
            this.rects[rn][lv][i] = new TreeRect((int)xx + 2, (int)ww - 2);
            xx += w;
        }
    }

    TreeRect[] treeRectsPerLevel(int rn, int lv) {
        return this.rects[rn][lv];
    }

    TreeRect treeRectPerIndex(int rn, int lv, int ix) {
        return this.rects[rn][lv][ix];
    }

    byte[] text(int pre) {
        return ViewData.label(this.view.gui.gopts, this.nodes.data(), pre);
    }

    private int calcOptimalRectWidth(byte[] string) {
        return BaseXLayout.width(this.g, string);
    }

    boolean bigRect(TreeSubtree sub, int rn, int lv) {
        return sub.levelSize(rn, lv) != this.rects[rn][lv].length;
    }

    int prePerXPos(TreeSubtree sub, int rn, int lv, int x) {
        TreeRect r = this.treeRectsPerLevel(rn, lv)[0];
        double ratio = (double)(x - r.x) / (double)r.w;
        int idx = (int)(ratio * (double)sub.levelSize(rn, lv));
        return sub.prePerIndex(rn, lv, idx);
    }

    TreeRect searchRect(TreeSubtree sub, int rn, int lv, int pre) {
        int i = sub.searchPreArrayPos(rn, lv, pre);
        return i < 0 ? null : this.rects[rn][lv][this.bigRect(sub, rn, lv) ? 0 : i];
    }
}

