/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.map.MapRect;
import org.basex.query.util.ft.FTPos;
import org.basex.util.FTToken;
import org.basex.util.Token;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class MapRenderer {
    private final Graphics g;
    private BoolList ttcol;
    private int ul;

    MapRenderer(Graphics g) {
        this.g = g;
    }

    int calcHeight(MapRect rect, byte[] text) {
        return this.drawText(rect, text, false);
    }

    void drawText(MapRect rect, byte[] text) {
        this.drawText(rect, text, true);
    }

    void chopText(byte[] text, int x, int y, int w) {
        BaseXLayout.chopString(this.g, text, x, y, w, GUIConstants.fontSize);
    }

    private int drawText(MapRect rect, byte[] text, boolean draw) {
        int fh = (int)(1.2 * (double)GUIConstants.fontSize);
        Color textc = this.g.getColor();
        int xx = rect.x;
        int yy = rect.y + fh;
        int ww = rect.w;
        int ll = 0;
        FTLexer lexer = new FTLexer().original().init(text);
        while (lexer.hasNext()) {
            FTSpan span = lexer.next();
            byte[] token = span.text;
            int wl = 0;
            int tl = token.length;
            for (int t = 0; t < tl; t += Token.cl(token, t)) {
                wl += BaseXLayout.width(this.g, Token.cp(token, t));
            }
            if (ll + wl >= ww) {
                xx = rect.x;
                if (ll != 0) {
                    yy += fh;
                }
                if (yy + fh > rect.y + rect.h) {
                    if (draw) {
                        this.g.drawString("...", xx + ll, yy);
                    }
                    return rect.h;
                }
                ll = 0;
                if (draw && wl >= ww) {
                    int l;
                    int n;
                    int twl = 2 * BaseXLayout.width(this.g, 46);
                    if (twl >= ww) {
                        return Integer.MAX_VALUE;
                    }
                    for (n = 0; n < tl && twl + (l = BaseXLayout.width(this.g, Token.cp(token, n))) < ww; n += Token.cl(token, n)) {
                        twl += l;
                    }
                    token = Arrays.copyOf(token, n + 2);
                    token[n] = 46;
                    token[n + 1] = 46;
                }
            }
            if (draw) {
                this.g.setColor(rect.pos != null && rect.pos.contains(span.pos) && !span.del ? GUIConstants.GREEN : textc);
                this.g.drawString(Token.string(token), xx + ll, yy);
            }
            ll += wl;
            if (!lexer.paragraph()) continue;
            ll = 0;
            if ((yy += fh) + fh <= rect.y + rect.h) continue;
            if (draw) {
                this.g.drawString("...", xx + ll, yy);
            }
            return rect.h;
        }
        return yy - rect.y;
    }

    void drawThumbnails(MapRect rect, byte[] text) {
        double fnew;
        double ffmax = 0.25;
        double ffhmax = 0.5;
        double flhmax = 0.3;
        double ff = 0.25;
        double ffh = 0.5;
        double flh = 0.3;
        byte lhmi = (byte)Math.max(3.0, ffh * (double)GUIConstants.fontSize);
        byte fhmi = (byte)Math.max(6.0, (flh + ffh) * (double)GUIConstants.fontSize);
        int h = rect.h;
        rect.thumbf = ff * (double)GUIConstants.fontSize;
        rect.thumbal = 0;
        int[][] data = new FTLexer().init(text).info();
        boolean l = false;
        double flhmin = 0.168;
        double ffhmin = 0.28;
        double ffmin = 0.14;
        double flhtmin = 0.168;
        double ffhtmax = 0.5;
        double ffhtmin = 0.28;
        double fftmax = 0.25;
        double fftmin = 0.14;
        double bflh = 0.3;
        double bffh = 0.5;
        double bff = 0.25;
        double flhtmax = 0.3;
        while (rect.thumbal < 2) {
            ff = MapRenderer.round(fftmax, fftmin);
            rect.thumbf = ff * (double)GUIConstants.fontSize;
            ffh = MapRenderer.round(ffhtmax, ffhtmin);
            rect.thumbfh = (byte)Math.max(1.0, ffh * (double)GUIConstants.fontSize);
            flh = MapRenderer.round(flhtmax, flhtmin);
            rect.thumblh = (byte)Math.max(1.0, (flh + ffh) * (double)GUIConstants.fontSize);
            rect.thumbsw = rect.thumbf;
            switch (rect.thumbal) {
                case 0: {
                    h = this.drawToken(rect, data, false);
                    break;
                }
                case 1: {
                    h = this.drawSentence(rect, data, false, rect.h);
                }
            }
            if (h >= rect.h || MapRenderer.le(0.25, ff) || MapRenderer.le(0.5, ffh) || MapRenderer.le(0.3, flh)) {
                if (l) {
                    rect.thumbf = bff * (double)GUIConstants.fontSize;
                    rect.thumbfh = (byte)Math.max(1.0, bffh * (double)GUIConstants.fontSize);
                    rect.thumblh = (byte)Math.max(1.0, (bflh + bffh) * (double)GUIConstants.fontSize);
                    rect.thumbsw = rect.thumbf;
                    switch (rect.thumbal) {
                        case 0: {
                            this.drawToken(rect, data, true);
                            return;
                        }
                        case 1: 
                        case 2: {
                            this.drawSentence(rect, data, true, rect.h);
                            return;
                        }
                    }
                }
                if (MapRenderer.le(ff, 0.14) || MapRenderer.le(ffh, 0.28) || MapRenderer.le(flh, 0.168)) {
                    rect.thumbal = (byte)(rect.thumbal + 1);
                    fhmi = rect.thumbfh;
                    lhmi = rect.thumblh;
                    fftmin = 0.14;
                    fftmax = 0.25;
                    ffhtmin = 0.28;
                    ffhtmax = 0.5;
                    flhtmin = 0.168;
                    flhtmax = 0.3;
                    continue;
                }
                fftmax = ff;
                ffhtmax = ffh;
                flhtmax = flh;
                continue;
            }
            l = true;
            bff = ff;
            bffh = ffh;
            bflh = flh;
            fftmin = ff;
            ffhtmin = ffh;
            flhtmin = flh;
        }
        double sum = data[3].length + data[4].length;
        double nl = ((double)rect.h - 3.0) / (double)lhmi;
        rect.thumbf = fnew = (nl * (double)(rect.w - 3) - (double)data[4].length) / sum;
        rect.thumbfh = fhmi;
        rect.thumblh = lhmi;
        rect.thumbsw = Math.max(1.0, fnew);
        this.drawSentence(rect, data, true, rect.h);
    }

    private int drawSentence(MapRect rect, int[][] data, boolean draw, int mh) {
        boolean sen = rect.thumbal == 1;
        FTPos ftp = rect.pos;
        int xx = rect.x;
        int ww = rect.w;
        int yy = rect.y + 3;
        Color textc = GUIConstants.color(rect.level + 4);
        this.g.setColor(textc);
        int count = -1;
        int pp = 0;
        int sl = 0;
        int pl = 0;
        int psl = 0;
        int ppl = 0;
        double error = 0.0;
        int i = 0;
        int ll = 0;
        int[] data0 = data[0];
        int[] data1 = data[1];
        int[] data2 = data[2];
        int dl0 = data0.length;
        int dl1 = data1.length;
        int dl2 = data2.length;
        while (i < dl0) {
            this.g.setColor(textc);
            int ct = 0;
            int wl = 0;
            while (i < dl0 && ppl < dl2 && data2[ppl] > pl && (psl >= dl1 || data1[psl] > sl)) {
                sl += data0[i];
                pl += data0[i];
                int lastl = (int)((double)data0[i] * rect.thumbf);
                if ((error += (double)data0[i] * rect.thumbf - (double)lastl) >= 1.0) {
                    wl += (int)error;
                    error -= (double)((int)error);
                }
                wl += lastl;
                if (ftp != null && ftp.contains(count)) {
                    ++ct;
                    ++pp;
                }
                ++count;
                ++i;
            }
            if (ct == 0) {
                while (ll + wl >= ww) {
                    if (draw) {
                        this.g.fillRect(xx + ll, yy, ww - ll, rect.thumbfh);
                    }
                    wl -= ww - ll;
                    ll = 0;
                    if ((yy += rect.thumblh) + rect.thumblh < rect.y + mh) continue;
                    return rect.h;
                }
                if (draw) {
                    this.g.fillRect(xx + ll, yy, wl, rect.thumbfh);
                }
                ll += wl;
            } else {
                int wltmp = wl / ct;
                for (int cttmp = 0; cttmp < ct; ++cttmp) {
                    if (pp - ct + cttmp < ftp.size()) {
                        this.g.setColor(GUIConstants.GREEN);
                    }
                    while (ll + wltmp >= ww) {
                        if (draw) {
                            this.g.fillRect(xx + ll, yy, ww - ll, rect.thumbfh);
                        }
                        wltmp -= ww - ll;
                        ll = 0;
                        if ((yy += rect.thumblh) + rect.thumblh < rect.y + mh) continue;
                        return rect.h;
                    }
                    if (draw) {
                        this.g.fillRect(xx + ll, yy, wltmp, rect.thumbfh);
                    }
                    ll += wltmp;
                    wltmp = wl / ct + (cttmp == ct - 2 ? wl - wl / ct * ct : 0);
                }
            }
            if (psl < dl1 && data1[psl] == sl) {
                if ((double)ll + rect.thumbsw >= (double)ww) {
                    ll = 0;
                    if ((yy += rect.thumblh) + rect.thumblh >= rect.y + mh) {
                        return rect.h;
                    }
                }
                if (draw) {
                    this.g.setColor(GUIConstants.TEXT);
                    this.g.fillRect(xx + ll, yy, (int)rect.thumbsw, rect.thumbfh);
                    this.g.setColor(textc);
                }
                ll = (int)((double)ll + rect.thumbsw);
                sl = 0;
                ++psl;
            }
            if (ppl >= dl2 || data2[ppl] != pl) continue;
            pl = 0;
            ++ppl;
            if (!sen) continue;
            ll = 0;
            if ((yy += rect.thumblh) + rect.thumblh < rect.y + mh) continue;
            return rect.h;
        }
        return yy - rect.y + rect.thumbfh;
    }

    private int drawToken(MapRect rect, int[][] data, boolean draw) {
        double xx = rect.x;
        double ww = rect.w;
        FTPos ftp = rect.pos;
        int yy = rect.y + 3;
        double ll = 0.0;
        double e = 0.0;
        Color textc = GUIConstants.color(rect.level + 4);
        int count = 0;
        int sl = 0;
        int pl = 0;
        int psl = 0;
        int ppl = 0;
        int[] data0 = data[0];
        int[] data1 = data[1];
        int[] data2 = data[2];
        int dl1 = data1.length;
        int dl2 = data2.length;
        for (int ad0 : data0) {
            int wl = (int)((double)ad0 * rect.thumbf);
            if ((e += (double)ad0 * rect.thumbf - (double)wl) >= 1.0) {
                wl += (int)e;
                e -= (double)((int)e);
            }
            pl += ad0;
            double d = ll + (double)wl;
            double d2 = rect.thumbsw;
            boolean bl = psl < dl1 && (sl += ad0) == data1[psl];
            if (d + d2 * (double)bl >= ww) {
                yy += rect.thumblh;
                ll = 0.0;
                if ((double)wl >= ww) {
                    return rect.h + 3;
                }
            }
            if (draw) {
                this.g.setColor(ftp != null && ftp.contains(count) ? GUIConstants.GREEN : textc);
                this.g.fillRect((int)(xx + ll), yy, wl, rect.thumbfh);
            }
            ll += (double)wl;
            ++count;
            if (psl < dl1 && sl == data1[psl]) {
                if (draw) {
                    this.g.setColor(GUIConstants.TEXT);
                    this.g.fillRect((int)(xx + ll), yy, (int)rect.thumbsw, rect.thumbfh);
                    this.g.setColor(textc);
                }
                ll += rect.thumbsw;
                ++psl;
                sl = 0;
            }
            ll += rect.thumbf;
            if (ppl >= dl2 || pl != data2[ppl]) continue;
            yy += rect.thumblh;
            ll = 0.0;
            ++ppl;
            pl = 0;
        }
        return yy - rect.y + 3;
    }

    TokenList computeToolTip(MapRect rect, int[][] data, int x, int y, int w) {
        if (rect.thumbf == 0.0) {
            return null;
        }
        boolean sen = rect.thumbal < 2;
        boolean ds = rect.thumbal < 1;
        FTPos ftp = rect.pos;
        int ww = rect.w;
        int yy = rect.y + 3;
        this.ul = -1;
        TokenList tl = new TokenList();
        this.ttcol = new BoolList();
        int cc = 0;
        int sl = 0;
        int pl = 0;
        int ppl = 0;
        int psl = 0;
        double error = 0.0;
        double ll = 0.0;
        int[] data0 = data[0];
        int[] data1 = data[1];
        int[] data2 = data[2];
        int[] data3 = data[3];
        int[] data4 = data[4];
        int dl0 = data0.length;
        int dl1 = data1.length;
        int dl2 = data2.length;
        int dl3 = data3.length;
        for (int i = 0; i < dl0; ++i) {
            boolean ir;
            double wl = (double)data0[i] * rect.thumbf;
            if ((error += (double)data0[i] * rect.thumbf - wl) >= 1.0) {
                wl += error;
                error -= (double)((int)error);
            }
            pl += data0[i];
            cc += data0[i];
            double d = ds && psl < dl1 && data1[psl] == (sl += data0[i]) ? rect.thumbsw : 0.0;
            if (ll + wl + d >= (double)ww) {
                if (!ds) {
                    wl -= (double)ww - ll;
                }
                ir = MapRenderer.inRect(rect.x, yy += rect.thumblh, wl, rect.thumbfh, x, y);
                ll = wl + (psl < dl1 && data1[psl] == sl ? rect.thumbsw : rect.thumbf);
            } else {
                ir = MapRenderer.inRect((double)rect.x + ll, yy, wl, rect.thumbfh, x, y);
                ll += wl + (ds ? rect.thumbf : 0.0);
            }
            if (ir) {
                int l;
                boolean apm;
                int p;
                int si = i;
                int sp = BaseXLayout.width(this.g, 32);
                int sd = BaseXLayout.width(this.g, 46);
                int bpsl = data1[psl] == sl ? psl + 1 : psl;
                int bsl = data1[psl] == sl ? 0 : sl;
                ll = (sd << 1) + sp;
                int n = p = cc >= data0[i] ? cc - data0[i] : 0;
                while (p > -1 && i > -1) {
                    apm = psl < dl1 && data1[psl] == sl;
                    byte[] tok = new byte[data0[i] + (apm ? 1 : 0)];
                    int ts = tok.length;
                    for (int k = 0; k < ts - (apm ? 1 : 0); ++k) {
                        tok[k] = (byte)data3[p + k];
                    }
                    if (apm) {
                        tok[ts - 1] = (byte)data4[psl];
                        ++sl;
                    }
                    if ((sl -= ts) == 0) {
                        if (--psl == -1) {
                            psl = dl1;
                        } else {
                            sl = data1[psl];
                        }
                    }
                    l = 0;
                    for (int n2 = 0; n2 < ts; n2 += Token.cl(tok, n2)) {
                        l += BaseXLayout.width(this.g, Token.cp(tok, n2));
                    }
                    if (si > i && ll + (double)l + (double)sp >= (double)w / 2.0) break;
                    ll += (double)(l + sp);
                    tl.add(tok);
                    this.ttcol.add(ftp != null && ftp.contains(i));
                    if (i == 0) break;
                    p -= data0[i - 1];
                    --i;
                }
                if (i > 0) {
                    tl.add(new byte[]{46, 46});
                    this.ttcol.add(false);
                }
                i = si + 1;
                p = cc;
                this.ul = tl.size() - 1;
                byte[][] toks = (byte[][])tl.next();
                boolean[] tc = this.ttcol.next();
                int tsl = toks.length;
                for (int j = tsl - 1; j >= 0; --j) {
                    tl.add(toks[j]);
                    this.ttcol.add(tc[j]);
                }
                ll = 0.0;
                sl = bsl;
                psl = bpsl;
                while (p < dl3 && i < dl0) {
                    apm = false;
                    if (psl < dl1 && data1[psl] == sl + data0[i]) {
                        apm = true;
                        sl = 0;
                        ++psl;
                    }
                    byte[] tok = new byte[data0[i] + (apm ? 1 : 0)];
                    int ts = tok.length;
                    l = 0;
                    for (int k = 0; k < ts - (apm ? 1 : 0); ++k) {
                        tok[k] = (byte)data3[p + k];
                    }
                    if (apm) {
                        tok[ts - 1] = (byte)data4[psl - 1];
                    }
                    sl += apm ? sl : ts;
                    for (int n3 = 0; n3 < ts; n3 += Token.cl(tok, n3)) {
                        l += BaseXLayout.width(this.g, Token.cp(tok, n3));
                    }
                    if (ll + (double)l + (double)sp + (double)(2 * sd) >= (double)w / 2.0) break;
                    ll += (double)(l + sp);
                    tl.add(tok);
                    this.ttcol.add(ftp != null && ftp.contains(i));
                    p += ts - (apm ? 1 : 0);
                    ++i;
                }
                if (i < dl0) {
                    tl.add(new byte[]{46, 46});
                    this.ttcol.add(false);
                }
                return tl;
            }
            if (ds && psl < dl1 && data1[psl] == sl) {
                if (ll + rect.thumbsw >= (double)ww) {
                    yy += rect.thumblh;
                    ll -= (double)ww;
                }
                ll += rect.thumbsw;
                sl = 0;
                ++psl;
            }
            if (ppl >= dl2 || data2[ppl] != pl) continue;
            pl = 0;
            ++ppl;
            if (!sen) continue;
            yy += rect.thumblh;
            ll = 0.0;
        }
        return tl;
    }

    void drawToolTip(MapRect rect, int x, int y, TokenList tl) {
        int xx;
        if (tl == null || tl.isEmpty()) {
            return;
        }
        int sw = BaseXLayout.width(this.g, 32);
        int wl = 0;
        int nl = 1;
        int wi = rect.w / 2;
        IntList len = new IntList();
        int ts = tl.size();
        for (int i = 0; i < ts; ++i) {
            int l = 0;
            byte[] tok = (byte[])tl.get(i);
            int ns = tok.length;
            for (int n = 0; n < ns; n += Token.cl(tok, n)) {
                l += BaseXLayout.width(this.g, Token.cp(tok, n));
            }
            if (wl + l + sw < wi) {
                wl += l + sw;
            } else {
                ++nl;
                if (l > wi) {
                    wi = l;
                }
                wl = l + sw;
            }
            len.add(l);
        }
        int ww = nl == 1 && wl < wi ? wl : wi;
        int n = xx = x + 10 + ww >= rect.x + rect.w ? rect.x + rect.w - ww - 2 : x + 10;
        int yy = y + 28 + GUIConstants.fontSize * nl + 4 < rect.y + rect.h ? y + 28 : (y - rect.y - 4 > GUIConstants.fontSize * nl ? y - GUIConstants.fontSize * nl : rect.y + rect.h - 4 - GUIConstants.fontSize * nl);
        this.g.setColor(GUIConstants.color(10));
        this.g.drawRect(xx - 3, yy - GUIConstants.fontSize - 1, ww + 3, GUIConstants.fontSize * nl + 7);
        this.g.setColor(GUIConstants.color(0));
        this.g.fillRect(xx - 2, yy - GUIConstants.fontSize, ww + 2, GUIConstants.fontSize * nl + 6);
        this.g.setColor(GUIConstants.color(20));
        wl = 0;
        int is = tl.size();
        for (int i = 0; i < is; ++i) {
            boolean pm;
            int l = len.get(i);
            if (wl + l + sw >= wi) {
                yy += GUIConstants.fontSize + 1;
                wl = 0;
            }
            boolean bl = pm = !FTToken.lod(((byte[])tl.get(i))[((byte[])tl.get(i)).length - 1]);
            if (this.ttcol.get(i)) {
                this.g.setColor(GUIConstants.GREEN);
            }
            this.g.drawString(Token.string((byte[])tl.get(i)), xx + wl, yy);
            if (i == this.ul) {
                this.g.drawLine(xx + wl, yy + 1, xx + wl + (pm ? l - sw : l), yy + 1);
            }
            this.g.setColor(GUIConstants.color(24));
            wl += l + sw;
        }
    }

    private static boolean inRect(double rx, int ry, double rw, int rh, int xx, int yy) {
        return (double)xx >= rx && (double)xx <= rx + rw && yy >= ry && yy <= ry + rh;
    }

    private static boolean le(double a, double b) {
        return a < b || a / b < 1.05;
    }

    private static double round(double a, double b) {
        double v = (a + b) / 2.0;
        double d = v * 100000.0;
        int i = (int)d;
        double r = d - (double)i >= 0.5 ? (double)(i + 1) : (double)i;
        return r / 100000.0;
    }
}

