/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;

public final class BaseXPopup
extends JPopupMenu {
    private final GUI gui;
    private final GUICommand[] commands;

    public BaseXPopup(BaseXPanel comp, GUICommand ... commands) {
        this((JComponent)comp, comp.gui, commands);
    }

    public BaseXPopup(JComponent comp, final GUI gui, GUICommand ... commands) {
        this.gui = gui;
        this.commands = commands;
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!gui.updating && e.isPopupTrigger()) {
                    BaseXPopup.this.show(e.getComponent(), e.getX() - 10, e.getY() - 15);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        });
        comp.addKeyListener(e -> {
            if (!gui.updating && BaseXKeys.CONTEXT.is(e)) {
                this.show(e.getComponent(), 10, 10);
            } else {
                for (GUICommand cmd : commands) {
                    if (!(cmd instanceof GUIPopupCmd)) continue;
                    for (BaseXKeys sc : ((GUIPopupCmd)cmd).shortcuts()) {
                        if (!sc.is(e)) continue;
                        cmd.execute(gui);
                        e.consume();
                        return;
                    }
                }
            }
        });
        StringBuilder mnemCache = new StringBuilder();
        for (GUICommand cmd : commands) {
            if (cmd == null) {
                this.addSeparator();
                continue;
            }
            JMenuItem item = GUIMenu.newItem(cmd, gui, mnemCache);
            item.setAccelerator(BaseXLayout.keyStroke(cmd));
            this.add(item);
        }
    }

    @Override
    public void show(Component comp, int x, int y) {
        int cl = this.commands.length;
        for (int c = 0; c < cl; ++c) {
            if (this.commands[c] == null) continue;
            AbstractButton button = (AbstractButton)this.getComponent(c);
            button.setEnabled(this.commands[c].enabled(this.gui));
            button.setSelected(this.commands[c].selected(this.gui));
        }
        super.show(comp, x, y);
    }
}

